/*
 * Decompiled with CFR 0.152.
 */
package com.tsongkha.spinnerdatepicker;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.app.AlertDialog;
import com.tsongkha.spinnerdatepicker.DatePicker;
import com.tsongkha.spinnerdatepicker.OnDateChangedListener;
import com.tsongkha.spinnerdatepicker.R;
import java.text.DateFormat;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String TITLE_SHOWN = "title_enabled";
    private static final String CUSTOM_TITLE = "custom_title";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mCallBack;
    private final OnDateCancelListener mOnCancel;
    private final DateFormat mTitleDateFormat;
    private boolean mIsDayShown = true;
    private boolean mIsTitleShown = true;
    private String mCustomTitle = "";

    DatePickerDialog(Context context, int theme, int spinnerTheme, OnDateSetListener callBack, OnDateCancelListener onCancel, Calendar defaultDate, Calendar minDate, Calendar maxDate, boolean isDayShown, boolean isTitleShown, String customTitle) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mOnCancel = onCancel;
        this.mTitleDateFormat = DateFormat.getDateInstance(1);
        this.mIsDayShown = isDayShown;
        this.mIsTitleShown = isTitleShown;
        this.mCustomTitle = customTitle;
        this.updateTitle(defaultDate);
        this.setButton(-1, context.getText(17039370), this);
        this.setButton(-2, context.getText(0x1040000), this);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_picker_dialog_container, null);
        this.setView(view);
        this.mDatePicker = new DatePicker((ViewGroup)view, spinnerTheme);
        this.mDatePicker.setMinDate(minDate.getTimeInMillis());
        this.mDatePicker.setMaxDate(maxDate.getTimeInMillis());
        this.mDatePicker.init(defaultDate.get(1), defaultDate.get(2), defaultDate.get(5), isDayShown, this);
    }

    public void onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -1: {
                if (this.mCallBack == null) break;
                this.mDatePicker.clearFocus();
                this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
                break;
            }
            case -2: {
                if (this.mOnCancel == null) break;
                this.mDatePicker.clearFocus();
                this.mOnCancel.onCancelled(this.mDatePicker);
            }
        }
    }

    @Override
    public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        Calendar updatedDate = Calendar.getInstance();
        updatedDate.set(1, year);
        updatedDate.set(2, monthOfYear);
        updatedDate.set(5, dayOfMonth);
        this.updateTitle(updatedDate);
    }

    private void updateTitle(Calendar updatedDate) {
        if (this.mIsTitleShown && this.mCustomTitle != null && !this.mCustomTitle.isEmpty()) {
            this.setTitle(this.mCustomTitle);
        } else if (this.mIsTitleShown) {
            DateFormat dateFormat = this.mTitleDateFormat;
            this.setTitle(dateFormat.format(updatedDate.getTime()));
        } else {
            this.setTitle(" ");
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        state.putBoolean(TITLE_SHOWN, this.mIsTitleShown);
        state.putString(CUSTOM_TITLE, this.mCustomTitle);
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mIsTitleShown = savedInstanceState.getBoolean(TITLE_SHOWN);
        this.mCustomTitle = savedInstanceState.getString(CUSTOM_TITLE);
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, day);
        this.updateTitle(c);
        this.mDatePicker.init(year, month, day, this.mIsDayShown, this);
    }

    public static interface OnDateCancelListener {
        public void onCancelled(DatePicker var1);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

