/*
 * Decompiled with CFR 0.152.
 */
package com.tsongkha.spinnerdatepicker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.tsongkha.spinnerdatepicker.DatePicker;
import com.tsongkha.spinnerdatepicker.DateUtils;
import com.tsongkha.spinnerdatepicker.R;
import java.text.DateFormat;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    public static int NO_YEAR = DatePicker.NO_YEAR;
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String YEAR_OPTIONAL = "year_optional";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mCallBack;
    private final DateFormat mTitleDateFormat;
    private final DateFormat mTitleNoYearDateFormat;
    private int mInitialYear;
    private int mInitialMonth;
    private int mInitialDay;

    DatePickerDialog(Context context, int theme, int spinnerTheme, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth, boolean yearOptional) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mInitialYear = year;
        this.mInitialMonth = monthOfYear;
        this.mInitialDay = dayOfMonth;
        this.mTitleDateFormat = DateFormat.getDateInstance(1);
        this.mTitleNoYearDateFormat = DateUtils.getLocalizedDateFormatWithoutYear(this.getContext());
        this.updateTitle(this.mInitialYear, this.mInitialMonth, this.mInitialDay);
        this.setButton(-1, context.getText(17039370), this);
        this.setButton(-2, context.getText(0x1040000), null);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_picker_dialog_container, null);
        this.setView(view);
        this.mDatePicker = new DatePicker(context, (ViewGroup)view, spinnerTheme);
        this.mDatePicker.init(this.mInitialYear, this.mInitialMonth, this.mInitialDay, yearOptional, this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
        }
    }

    @Override
    public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
        this.updateTitle(year, monthOfYear, dayOfMonth);
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mInitialYear = year;
        this.mInitialMonth = monthOfYear;
        this.mInitialDay = dayOfMonth;
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    private void updateTitle(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        DateFormat dateFormat = year == NO_YEAR ? this.mTitleNoYearDateFormat : this.mTitleDateFormat;
        this.setTitle(dateFormat.format(calendar.getTime()));
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        state.putBoolean(YEAR_OPTIONAL, this.mDatePicker.isYearOptional());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        boolean yearOptional = savedInstanceState.getBoolean(YEAR_OPTIONAL);
        this.mDatePicker.init(year, month, day, yearOptional, this);
        this.updateTitle(year, month, day);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

