/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.utils;

import it.kamaladafrica.codicefiscale.CodiceFiscale;
import it.kamaladafrica.codicefiscale.utils.RegexUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class PartUtils {
    public static final String EMPTY_STRING = "";
    public static final String PLACEHOLDER = "X";

    public static String normalizeString(String s) {
        return RegexUtils.extract(RegexUtils.CF_ALLOWED_CHARS, StringUtils.defaultString((String)s).toUpperCase(CodiceFiscale.LOCALE));
    }

    public static String extractConsonants(String s) {
        Validate.notNull((Object)s);
        return RegexUtils.extract(RegexUtils.CONSONANT_PATTERN, s);
    }

    public static String extractVowels(String s) {
        Validate.notNull((Object)s);
        return RegexUtils.extract(RegexUtils.VOWEL_PATTERN, s);
    }

    public static boolean hasVowels(String s) {
        return !PartUtils.extractVowels(s).isEmpty();
    }

    public static String removePlaceholderIfPresent(String s) {
        if (PartUtils.hasVowels(s)) {
            return StringUtils.removeEnd((String)s, (String)PLACEHOLDER);
        }
        return s;
    }

    @Generated
    private PartUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

