/*
 * Decompiled with CFR 0.152.
 */
package it.kamaladafrica.codicefiscale.internal;

import com.google.common.primitives.ImmutableIntArray;
import it.kamaladafrica.codicefiscale.internal.AbstractPart;
import it.kamaladafrica.codicefiscale.utils.OmocodeUtils;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.commons.lang3.Validate;

public final class DatePart
extends AbstractPart {
    private static final String VALIDATION_PATTERN = "^(?:[\\dLMNP-V]{2}(?:[A-EHLMPR-T](?:[04LQ][1-9MNP-V]|[15MR][\\dLMNP-V]|[26NS][0-8LMNP-U])|[DHPS][37PT][0L]|[ACELMRT][37PT][01LM]|[AC-EHLMPR-T][26NS][9V])|(?:[02468LNQSU][048LQU]|[13579MPRTV][26NS])B[26NS][9V])$";
    private static final ImmutableIntArray OMOCODE_INDEXES = ImmutableIntArray.of((int)4, (int)3, (int)1, (int)0);
    private static final String DATE_PART_FORMAT = "%02d%s%02d";
    private static final String MONTHS_CHARS = "ABCDEHLMPRST";
    private static final int FEMAIL_DAY_OFFSET = 40;
    private static final int MILLENNIUM = LocalDate.now().getYear() / 1000 * 1000;
    private final LocalDate date;
    private final boolean female;

    private DatePart(LocalDate date, boolean female, int level) {
        super(level);
        Validate.inclusiveBetween((Object)0, (Object)OMOCODE_INDEXES.length(), (Comparable)Integer.valueOf(level), (String)"invalid omocode level for date part: 0 <= %s <= %s", (Object[])new Object[]{level, OMOCODE_INDEXES.length()});
        this.date = date;
        this.female = female;
    }

    public static DatePart from(String value) {
        Validate.notEmpty((CharSequence)value, (String)"invalid value: %s", (Object[])new Object[]{value});
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        DatePartInput input = DatePart.toInput(value);
        return new DatePart(input.getDate(), input.isFemale(), DatePart.getOmocodeLevel(value));
    }

    private static int getOmocodeLevel(String value) {
        return OmocodeUtils.level(value, OMOCODE_INDEXES.toArray());
    }

    public static DatePart of(LocalDate date, boolean isFemale) {
        Validate.notNull((Object)date);
        return new DatePart(date, isFemale);
    }

    @Override
    protected String computeValue() {
        int day = this.date.getDayOfMonth();
        int month = this.date.getMonth().getValue() - 1;
        int year = this.date.getYear() % 100;
        if (this.isFemale()) {
            day += 40;
        }
        String value = String.format(DATE_PART_FORMAT, year, Character.valueOf(MONTHS_CHARS.charAt(month)), day);
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"invalid value: %s", (Object[])new Object[]{value});
        return value;
    }

    private static DatePartInput toInput(String value) {
        LocalDate date;
        boolean female;
        value = DatePart.normalizeOmocode(value);
        int year = Integer.parseInt(value.substring(0, 2)) + MILLENNIUM;
        int month = 1 + MONTHS_CHARS.indexOf(value.substring(2, 3));
        int day = Integer.parseInt(value.substring(3, 5));
        boolean bl = female = day > 40;
        if (female) {
            day -= 40;
        }
        if ((date = LocalDate.of(year, month, day)).isAfter(LocalDate.now())) {
            date = date.minusYears(100L);
        }
        return new DatePartInput(date, female);
    }

    private static String normalizeOmocode(String value) {
        return OmocodeUtils.normalize(value, OMOCODE_INDEXES.toArray());
    }

    @Override
    protected String applyOmocodeLevel(String value) {
        int level = this.getOmocodeLevel();
        if (level > 0) {
            return OmocodeUtils.apply(value, OMOCODE_INDEXES.subArray(0, level).toArray());
        }
        return value;
    }

    public DatePart toOmocodeLevel(int level) {
        return this.getOmocodeLevel() == level ? this : new DatePart(this.date, this.female, level);
    }

    @Override
    protected void validateValue(String value) {
        Validate.matchesPattern((CharSequence)value, (String)VALIDATION_PATTERN, (String)"unexpected result: %s", (Object[])new Object[]{value});
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public boolean isFemale() {
        return this.female;
    }

    @Generated
    private DatePart(LocalDate date, boolean female) {
        this.date = date;
        this.female = female;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatePart)) {
            return false;
        }
        DatePart other = (DatePart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        return this.isFemale() == other.isFemale();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatePart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        result = result * 59 + (this.isFemale() ? 79 : 97);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DatePart(super=" + super.toString() + ", date=" + this.getDate() + ", female=" + this.isFemale() + ")";
    }

    private static final class DatePartInput {
        private final LocalDate date;
        private final boolean female;

        @Generated
        public DatePartInput(LocalDate date, boolean female) {
            this.date = date;
            this.female = female;
        }

        @Generated
        public LocalDate getDate() {
            return this.date;
        }

        @Generated
        public boolean isFemale() {
            return this.female;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatePartInput)) {
                return false;
            }
            DatePartInput other = (DatePartInput)o;
            LocalDate this$date = this.getDate();
            LocalDate other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            return this.isFemale() == other.isFemale();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LocalDate $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            result = result * 59 + (this.isFemale() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "DatePart.DatePartInput(date=" + this.getDate() + ", female=" + this.isFemale() + ")";
        }
    }
}

