/*
 * Decompiled with CFR 0.152.
 */
package io.github.douglasjunior.androidSimpleTooltip;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import io.github.douglasjunior.androidSimpleTooltip.ArrowDrawable;
import io.github.douglasjunior.androidSimpleTooltip.OverlayView;
import io.github.douglasjunior.androidSimpleTooltip.R;
import io.github.douglasjunior.androidSimpleTooltip.SimpleTooltipUtils;

public class SimpleTooltip
implements PopupWindow.OnDismissListener {
    private static final String TAG = SimpleTooltip.class.getSimpleName();
    private static final int mDefaultPopupWindowStyleRes = 16842870;
    private static final int mDefaultTextAppearanceRes = R.style.simpletooltip_default;
    private static final int mDefaultBackgroundColorRes = R.color.simpletooltip_background;
    private static final int mDefaultTextColorRes = R.color.simpletooltip_text;
    private static final int mDefaultArrowColorRes = R.color.simpletooltip_arrow;
    private static final int mDefaultMarginRes = R.dimen.simpletooltip_margin;
    private static final int mDefaultPaddingRes = R.dimen.simpletooltip_padding;
    private static final int mDefaultAnimationPaddingRes = R.dimen.simpletooltip_animation_padding;
    private static final int mDefaultAnimationDurationRes = R.integer.simpletooltip_animation_duration;
    private static final int mDefaultArrowWidthRes = R.dimen.simpletooltip_arrow_width;
    private static final int mDefaultArrowHeightRes = R.dimen.simpletooltip_arrow_height;
    private static final int mDefaultOverlayOffsetRes = R.dimen.simpletooltip_overlay_offset;
    private final Context mContext;
    private OnDismissListener mOnDismissListener;
    private OnShowListener mOnShowListener;
    private PopupWindow mPopupWindow;
    private final int mGravity;
    private final int mArrowDirection;
    private final boolean mDismissOnInsideTouch;
    private final boolean mDismissOnOutsideTouch;
    private final boolean mModal;
    private final View mContentView;
    private View mContentLayout;
    @IdRes
    private final int mTextViewId;
    private final int mOverlayWindowBackgroundColor;
    private final CharSequence mText;
    private final View mAnchorView;
    private final boolean mTransparentOverlay;
    private final float mOverlayOffset;
    private final boolean mOverlayMatchParent;
    private final float mMaxWidth;
    private View mOverlay;
    private ViewGroup mRootView;
    private final boolean mShowArrow;
    private ImageView mArrowView;
    private final Drawable mArrowDrawable;
    private final boolean mAnimated;
    private AnimatorSet mAnimator;
    private final float mMargin;
    private final float mPadding;
    private final float mAnimationPadding;
    private final long mAnimationDuration;
    private final float mArrowWidth;
    private final float mArrowHeight;
    private final boolean mFocusable;
    private boolean dismissed = false;
    private int mHighlightShape;
    private int width;
    private int height;
    private boolean mIgnoreOverlay;
    private float cornerRadius;
    private final View.OnTouchListener mOverlayTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            return SimpleTooltip.this.mModal;
        }
    };
    private final ViewTreeObserver.OnGlobalLayoutListener mLocationLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            PopupWindow popup = SimpleTooltip.this.mPopupWindow;
            if (popup == null || SimpleTooltip.this.dismissed) {
                return;
            }
            if (SimpleTooltip.this.mMaxWidth > 0.0f && (float)SimpleTooltip.this.mContentView.getWidth() > SimpleTooltip.this.mMaxWidth) {
                SimpleTooltipUtils.setWidth(SimpleTooltip.this.mContentView, SimpleTooltip.this.mMaxWidth);
                popup.update(-2, -2);
                return;
            }
            SimpleTooltipUtils.removeOnGlobalLayoutListener(popup.getContentView(), this);
            popup.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mArrowLayoutListener);
            PointF location = SimpleTooltip.this.calculePopupLocation();
            popup.setClippingEnabled(true);
            popup.update((int)location.x, (int)location.y, popup.getWidth(), popup.getHeight());
            popup.getContentView().requestLayout();
            SimpleTooltip.this.createOverlay();
        }
    };
    private final ViewTreeObserver.OnGlobalLayoutListener mArrowLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            PopupWindow popup = SimpleTooltip.this.mPopupWindow;
            if (popup == null || SimpleTooltip.this.dismissed) {
                return;
            }
            SimpleTooltipUtils.removeOnGlobalLayoutListener(popup.getContentView(), this);
            popup.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mAnimationLayoutListener);
            popup.getContentView().getViewTreeObserver().addOnGlobalLayoutListener(SimpleTooltip.this.mShowLayoutListener);
            if (SimpleTooltip.this.mShowArrow) {
                float y;
                float x;
                RectF achorRect = SimpleTooltipUtils.calculeRectOnScreen(SimpleTooltip.this.mAnchorView);
                RectF contentViewRect = SimpleTooltipUtils.calculeRectOnScreen(SimpleTooltip.this.mContentLayout);
                if (SimpleTooltip.this.mArrowDirection == 1 || SimpleTooltip.this.mArrowDirection == 3) {
                    x = (float)SimpleTooltip.this.mContentLayout.getPaddingLeft() + SimpleTooltipUtils.pxFromDp(2.0f);
                    float centerX = contentViewRect.width() / 2.0f - (float)SimpleTooltip.this.mArrowView.getWidth() / 2.0f;
                    float newX = centerX - (contentViewRect.centerX() - achorRect.centerX());
                    if (newX > x) {
                        x = newX + (float)SimpleTooltip.this.mArrowView.getWidth() + x > contentViewRect.width() ? contentViewRect.width() - (float)SimpleTooltip.this.mArrowView.getWidth() - x : newX;
                    }
                    y = SimpleTooltip.this.mArrowView.getTop();
                    y += (float)(SimpleTooltip.this.mArrowDirection == 3 ? -1 : 1);
                } else {
                    y = (float)SimpleTooltip.this.mContentLayout.getPaddingTop() + SimpleTooltipUtils.pxFromDp(2.0f);
                    float centerY = contentViewRect.height() / 2.0f - (float)SimpleTooltip.this.mArrowView.getHeight() / 2.0f;
                    float newY = centerY - (contentViewRect.centerY() - achorRect.centerY());
                    if (newY > y) {
                        y = newY + (float)SimpleTooltip.this.mArrowView.getHeight() + y > contentViewRect.height() ? contentViewRect.height() - (float)SimpleTooltip.this.mArrowView.getHeight() - y : newY;
                    }
                    x = SimpleTooltip.this.mArrowView.getLeft();
                    x += (float)(SimpleTooltip.this.mArrowDirection == 2 ? -1 : 1);
                }
                SimpleTooltipUtils.setX((View)SimpleTooltip.this.mArrowView, (int)x);
                SimpleTooltipUtils.setY((View)SimpleTooltip.this.mArrowView, (int)y);
            }
            popup.getContentView().requestLayout();
        }
    };
    private final ViewTreeObserver.OnGlobalLayoutListener mShowLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            PopupWindow popup = SimpleTooltip.this.mPopupWindow;
            if (popup == null || SimpleTooltip.this.dismissed) {
                return;
            }
            SimpleTooltipUtils.removeOnGlobalLayoutListener(popup.getContentView(), this);
            if (SimpleTooltip.this.mOnShowListener != null) {
                SimpleTooltip.this.mOnShowListener.onShow(SimpleTooltip.this);
            }
            SimpleTooltip.this.mOnShowListener = null;
            SimpleTooltip.this.mContentLayout.setVisibility(0);
        }
    };
    private final ViewTreeObserver.OnGlobalLayoutListener mAnimationLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            PopupWindow popup = SimpleTooltip.this.mPopupWindow;
            if (popup == null || SimpleTooltip.this.dismissed) {
                return;
            }
            SimpleTooltipUtils.removeOnGlobalLayoutListener(popup.getContentView(), this);
            if (SimpleTooltip.this.mAnimated) {
                SimpleTooltip.this.startAnimation();
            }
            popup.getContentView().requestLayout();
        }
    };
    private final ViewTreeObserver.OnGlobalLayoutListener mAutoDismissLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            PopupWindow popup = SimpleTooltip.this.mPopupWindow;
            if (popup == null || SimpleTooltip.this.dismissed) {
                return;
            }
            if (!SimpleTooltip.this.mRootView.isShown()) {
                SimpleTooltip.this.dismiss();
            }
        }
    };

    private SimpleTooltip(Builder builder) {
        this.mContext = builder.context;
        this.mGravity = builder.gravity;
        this.mOverlayWindowBackgroundColor = builder.overlayWindowBackgroundColor;
        this.mArrowDirection = builder.arrowDirection;
        this.mDismissOnInsideTouch = builder.dismissOnInsideTouch;
        this.mDismissOnOutsideTouch = builder.dismissOnOutsideTouch;
        this.mModal = builder.modal;
        this.mContentView = builder.contentView;
        this.mTextViewId = builder.textViewId;
        this.mText = builder.text;
        this.mAnchorView = builder.anchorView;
        this.mTransparentOverlay = builder.transparentOverlay;
        this.mOverlayOffset = builder.overlayOffset;
        this.mOverlayMatchParent = builder.overlayMatchParent;
        this.mMaxWidth = builder.maxWidth;
        this.mShowArrow = builder.showArrow;
        this.mArrowWidth = builder.arrowWidth;
        this.mArrowHeight = builder.arrowHeight;
        this.mArrowDrawable = builder.arrowDrawable;
        this.mAnimated = builder.animated;
        this.mMargin = builder.margin;
        this.mPadding = builder.padding;
        this.mAnimationPadding = builder.animationPadding;
        this.mAnimationDuration = builder.animationDuration;
        this.mOnDismissListener = builder.onDismissListener;
        this.mOnShowListener = builder.onShowListener;
        this.mFocusable = builder.focusable;
        this.mRootView = SimpleTooltipUtils.findFrameLayout(this.mAnchorView);
        this.mHighlightShape = builder.highlightShape;
        this.mIgnoreOverlay = builder.ignoreOverlay;
        this.width = builder.width;
        this.height = builder.height;
        this.cornerRadius = builder.cornerRadius;
        this.init();
    }

    private void init() {
        this.configPopupWindow();
        this.configContentView();
    }

    private void configPopupWindow() {
        this.mPopupWindow = new PopupWindow(this.mContext, null, 16842870);
        this.mPopupWindow.setOnDismissListener((PopupWindow.OnDismissListener)this);
        this.mPopupWindow.setWidth(this.width);
        this.mPopupWindow.setHeight(this.height);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                int x = (int)event.getX();
                int y = (int)event.getY();
                if (!(SimpleTooltip.this.mDismissOnOutsideTouch || event.getAction() != 0 || x >= 0 && x < SimpleTooltip.this.mContentLayout.getMeasuredWidth() && y >= 0 && y < SimpleTooltip.this.mContentLayout.getMeasuredHeight())) {
                    return true;
                }
                if (!SimpleTooltip.this.mDismissOnOutsideTouch && event.getAction() == 4) {
                    return true;
                }
                if (event.getAction() == 0 && SimpleTooltip.this.mDismissOnInsideTouch) {
                    SimpleTooltip.this.dismiss();
                    return true;
                }
                return false;
            }
        });
        this.mPopupWindow.setClippingEnabled(false);
        this.mPopupWindow.setFocusable(this.mFocusable);
    }

    public void show() {
        this.verifyDismissed();
        this.mContentLayout.getViewTreeObserver().addOnGlobalLayoutListener(this.mLocationLayoutListener);
        this.mContentLayout.getViewTreeObserver().addOnGlobalLayoutListener(this.mAutoDismissLayoutListener);
        this.mRootView.post(new Runnable(){

            @Override
            public void run() {
                if (SimpleTooltip.this.mRootView.isShown()) {
                    SimpleTooltip.this.mPopupWindow.showAtLocation((View)SimpleTooltip.this.mRootView, 0, SimpleTooltip.this.mRootView.getWidth(), SimpleTooltip.this.mRootView.getHeight());
                    if (SimpleTooltip.this.mFocusable) {
                        SimpleTooltip.this.mContentLayout.requestFocus();
                    }
                } else {
                    Log.e((String)TAG, (String)"Tooltip cannot be shown, root view is invalid or has been closed.");
                }
            }
        });
    }

    private void verifyDismissed() {
        if (this.dismissed) {
            throw new IllegalArgumentException("Tooltip has been dismissed.");
        }
    }

    private void createOverlay() {
        if (this.mIgnoreOverlay) {
            return;
        }
        Object object = this.mOverlay = this.mTransparentOverlay ? new View(this.mContext) : new OverlayView(this.mContext, this.mAnchorView, this.mHighlightShape, this.mOverlayOffset, this.mOverlayWindowBackgroundColor, this.cornerRadius);
        if (this.mOverlayMatchParent) {
            this.mOverlay.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            this.mOverlay.setLayoutParams(new ViewGroup.LayoutParams(this.mRootView.getWidth(), this.mRootView.getHeight()));
        }
        this.mOverlay.setOnTouchListener(this.mOverlayTouchListener);
        this.mRootView.addView(this.mOverlay);
    }

    private PointF calculePopupLocation() {
        PointF location = new PointF();
        RectF anchorRect = SimpleTooltipUtils.calculeRectInWindow(this.mAnchorView);
        PointF anchorCenter = new PointF(anchorRect.centerX(), anchorRect.centerY());
        switch (this.mGravity) {
            case 0x800003: {
                location.x = anchorRect.left - (float)this.mPopupWindow.getContentView().getWidth() - this.mMargin;
                location.y = anchorCenter.y - (float)this.mPopupWindow.getContentView().getHeight() / 2.0f;
                break;
            }
            case 0x800005: {
                location.x = anchorRect.right + this.mMargin;
                location.y = anchorCenter.y - (float)this.mPopupWindow.getContentView().getHeight() / 2.0f;
                break;
            }
            case 48: {
                location.x = anchorCenter.x - (float)this.mPopupWindow.getContentView().getWidth() / 2.0f;
                location.y = anchorRect.top - (float)this.mPopupWindow.getContentView().getHeight() - this.mMargin;
                break;
            }
            case 80: {
                location.x = anchorCenter.x - (float)this.mPopupWindow.getContentView().getWidth() / 2.0f;
                location.y = anchorRect.bottom + this.mMargin;
                break;
            }
            case 17: {
                location.x = anchorCenter.x - (float)this.mPopupWindow.getContentView().getWidth() / 2.0f;
                location.y = anchorCenter.y - (float)this.mPopupWindow.getContentView().getHeight() / 2.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Gravity must have be CENTER, START, END, TOP or BOTTOM.");
            }
        }
        return location;
    }

    private void configContentView() {
        TextView tv;
        if (this.mContentView instanceof TextView) {
            tv = (TextView)this.mContentView;
            tv.setText(this.mText);
        } else {
            tv = (TextView)this.mContentView.findViewById(this.mTextViewId);
            if (tv != null) {
                tv.setText(this.mText);
            }
        }
        this.mContentView.setPadding((int)this.mPadding, (int)this.mPadding, (int)this.mPadding, (int)this.mPadding);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        linearLayout.setOrientation(this.mArrowDirection == 0 || this.mArrowDirection == 2 ? 0 : 1);
        int layoutPadding = (int)(this.mAnimated ? this.mAnimationPadding : 0.0f);
        linearLayout.setPadding(layoutPadding, layoutPadding, layoutPadding, layoutPadding);
        if (this.mShowArrow) {
            this.mArrowView = new ImageView(this.mContext);
            this.mArrowView.setImageDrawable(this.mArrowDrawable);
            LinearLayout.LayoutParams arrowLayoutParams = this.mArrowDirection == 1 || this.mArrowDirection == 3 ? new LinearLayout.LayoutParams((int)this.mArrowWidth, (int)this.mArrowHeight, 0.0f) : new LinearLayout.LayoutParams((int)this.mArrowHeight, (int)this.mArrowWidth, 0.0f);
            arrowLayoutParams.gravity = 17;
            this.mArrowView.setLayoutParams((ViewGroup.LayoutParams)arrowLayoutParams);
            if (this.mArrowDirection == 3 || this.mArrowDirection == 2) {
                linearLayout.addView(this.mContentView);
                linearLayout.addView((View)this.mArrowView);
            } else {
                linearLayout.addView((View)this.mArrowView);
                linearLayout.addView(this.mContentView);
            }
        } else {
            linearLayout.addView(this.mContentView);
        }
        LinearLayout.LayoutParams contentViewParams = new LinearLayout.LayoutParams(this.width, this.height, 0.0f);
        contentViewParams.gravity = 17;
        this.mContentView.setLayoutParams((ViewGroup.LayoutParams)contentViewParams);
        this.mContentLayout = linearLayout;
        this.mContentLayout.setVisibility(4);
        if (this.mFocusable) {
            this.mContentLayout.setFocusableInTouchMode(true);
            this.mContentLayout.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View v, int keyCode, KeyEvent event) {
                    if (event.getAction() == 1) {
                        switch (keyCode) {
                            case 23: 
                            case 62: 
                            case 66: 
                            case 160: {
                                SimpleTooltip.this.dismiss();
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
        }
        this.mPopupWindow.setContentView(this.mContentLayout);
    }

    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow != null && this.mPopupWindow.isShowing();
    }

    public <T extends View> T findViewById(int id2) {
        return (T)this.mContentLayout.findViewById(id2);
    }

    public void onDismiss() {
        this.dismissed = true;
        if (Build.VERSION.SDK_INT >= 11 && this.mAnimator != null) {
            this.mAnimator.removeAllListeners();
            this.mAnimator.end();
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        if (this.mRootView != null && this.mOverlay != null) {
            this.mRootView.removeView(this.mOverlay);
        }
        this.mRootView = null;
        this.mOverlay = null;
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(this);
        }
        this.mOnDismissListener = null;
        SimpleTooltipUtils.removeOnGlobalLayoutListener(this.mPopupWindow.getContentView(), this.mLocationLayoutListener);
        SimpleTooltipUtils.removeOnGlobalLayoutListener(this.mPopupWindow.getContentView(), this.mArrowLayoutListener);
        SimpleTooltipUtils.removeOnGlobalLayoutListener(this.mPopupWindow.getContentView(), this.mShowLayoutListener);
        SimpleTooltipUtils.removeOnGlobalLayoutListener(this.mPopupWindow.getContentView(), this.mAnimationLayoutListener);
        SimpleTooltipUtils.removeOnGlobalLayoutListener(this.mPopupWindow.getContentView(), this.mAutoDismissLayoutListener);
        this.mPopupWindow = null;
    }

    @TargetApi(value=11)
    private void startAnimation() {
        String property = this.mGravity == 48 || this.mGravity == 80 ? "translationY" : "translationX";
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)this.mContentLayout, (String)property, (float[])new float[]{-this.mAnimationPadding, this.mAnimationPadding});
        anim1.setDuration(this.mAnimationDuration);
        anim1.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)this.mContentLayout, (String)property, (float[])new float[]{this.mAnimationPadding, -this.mAnimationPadding});
        anim2.setDuration(this.mAnimationDuration);
        anim2.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mAnimator = new AnimatorSet();
        this.mAnimator.playSequentially(new Animator[]{anim1, anim2});
        this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!SimpleTooltip.this.dismissed && SimpleTooltip.this.isShowing()) {
                    animation.start();
                }
            }
        });
        this.mAnimator.start();
    }

    public static class Builder {
        private final Context context;
        private boolean dismissOnInsideTouch = true;
        private boolean dismissOnOutsideTouch = true;
        private boolean modal = false;
        private View contentView;
        @IdRes
        private int textViewId = 16908308;
        private CharSequence text = "";
        private View anchorView;
        private int arrowDirection = 4;
        private int gravity = 80;
        private boolean transparentOverlay = true;
        private float overlayOffset = -1.0f;
        private boolean overlayMatchParent = true;
        private float maxWidth;
        private boolean showArrow = true;
        private Drawable arrowDrawable;
        private boolean animated = false;
        private float margin = -1.0f;
        private float padding = -1.0f;
        private float animationPadding = -1.0f;
        private OnDismissListener onDismissListener;
        private OnShowListener onShowListener;
        private long animationDuration;
        private int backgroundColor;
        private int textColor;
        private int arrowColor;
        private float arrowHeight;
        private float arrowWidth;
        private boolean focusable;
        private float cornerRadius;
        private int highlightShape = 0;
        private int width = -2;
        private int height = -2;
        private boolean ignoreOverlay = false;
        private int overlayWindowBackgroundColor = 0;

        public Builder(Context context) {
            this.context = context;
            this.focusable = !context.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }

        public SimpleTooltip build() throws IllegalArgumentException {
            this.validateArguments();
            if (this.backgroundColor == 0) {
                this.backgroundColor = SimpleTooltipUtils.getColor(this.context, mDefaultBackgroundColorRes);
            }
            if (this.overlayWindowBackgroundColor == 0) {
                this.overlayWindowBackgroundColor = -16777216;
            }
            if (this.textColor == 0) {
                this.textColor = SimpleTooltipUtils.getColor(this.context, mDefaultTextColorRes);
            }
            if (this.contentView == null) {
                TextView tv = new TextView(this.context);
                SimpleTooltipUtils.setTextAppearance(tv, mDefaultTextAppearanceRes);
                tv.setBackgroundColor(this.backgroundColor);
                tv.setTextColor(this.textColor);
                this.contentView = tv;
            }
            if (this.arrowColor == 0) {
                this.arrowColor = SimpleTooltipUtils.getColor(this.context, mDefaultArrowColorRes);
            }
            if (this.margin < 0.0f) {
                this.margin = this.context.getResources().getDimension(mDefaultMarginRes);
            }
            if (this.padding < 0.0f) {
                this.padding = this.context.getResources().getDimension(mDefaultPaddingRes);
            }
            if (this.animationPadding < 0.0f) {
                this.animationPadding = this.context.getResources().getDimension(mDefaultAnimationPaddingRes);
            }
            if (this.animationDuration == 0L) {
                this.animationDuration = this.context.getResources().getInteger(mDefaultAnimationDurationRes);
            }
            if (Build.VERSION.SDK_INT < 11) {
                this.animated = false;
            }
            if (this.showArrow) {
                if (this.arrowDirection == 4) {
                    this.arrowDirection = SimpleTooltipUtils.tooltipGravityToArrowDirection(this.gravity);
                }
                if (this.arrowDrawable == null) {
                    this.arrowDrawable = new ArrowDrawable(this.arrowColor, this.arrowDirection);
                }
                if (this.arrowWidth == 0.0f) {
                    this.arrowWidth = this.context.getResources().getDimension(mDefaultArrowWidthRes);
                }
                if (this.arrowHeight == 0.0f) {
                    this.arrowHeight = this.context.getResources().getDimension(mDefaultArrowHeightRes);
                }
            }
            if (this.highlightShape < 0 || this.highlightShape > 2) {
                this.highlightShape = 0;
            }
            if (this.overlayOffset < 0.0f) {
                this.overlayOffset = this.context.getResources().getDimension(mDefaultOverlayOffsetRes);
            }
            return new SimpleTooltip(this);
        }

        private void validateArguments() throws IllegalArgumentException {
            if (this.context == null) {
                throw new IllegalArgumentException("Context not specified.");
            }
            if (this.anchorView == null) {
                throw new IllegalArgumentException("Anchor view not specified.");
            }
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder contentView(TextView textView) {
            this.contentView = textView;
            this.textViewId = 0;
            return this;
        }

        public Builder contentView(View contentView, @IdRes int textViewId) {
            this.contentView = contentView;
            this.textViewId = textViewId;
            return this;
        }

        public Builder contentView(@LayoutRes int contentViewId, @IdRes int textViewId) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            this.contentView = inflater.inflate(contentViewId, null, false);
            this.textViewId = textViewId;
            return this;
        }

        public Builder contentView(@LayoutRes int contentViewId) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            this.contentView = inflater.inflate(contentViewId, null, false);
            this.textViewId = 0;
            return this;
        }

        public Builder dismissOnInsideTouch(boolean dismissOnInsideTouch) {
            this.dismissOnInsideTouch = dismissOnInsideTouch;
            return this;
        }

        public Builder dismissOnOutsideTouch(boolean dismissOnOutsideTouch) {
            this.dismissOnOutsideTouch = dismissOnOutsideTouch;
            return this;
        }

        public Builder modal(boolean modal) {
            this.modal = modal;
            return this;
        }

        public Builder text(CharSequence text) {
            this.text = text;
            return this;
        }

        public Builder text(@StringRes int textRes) {
            this.text = this.context.getString(textRes);
            return this;
        }

        public Builder anchorView(View anchorView) {
            this.anchorView = anchorView;
            return this;
        }

        public Builder gravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder arrowDirection(int arrowDirection) {
            this.arrowDirection = arrowDirection;
            return this;
        }

        public Builder transparentOverlay(boolean transparentOverlay) {
            this.transparentOverlay = transparentOverlay;
            return this;
        }

        public Builder maxWidth(@DimenRes int maxWidthRes) {
            this.maxWidth = this.context.getResources().getDimension(maxWidthRes);
            return this;
        }

        public Builder maxWidth(float maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        @TargetApi(value=11)
        public Builder animated(boolean animated) {
            this.animated = animated;
            return this;
        }

        @TargetApi(value=11)
        public Builder animationPadding(float animationPadding) {
            this.animationPadding = animationPadding;
            return this;
        }

        @TargetApi(value=11)
        public Builder animationPadding(@DimenRes int animationPaddingRes) {
            this.animationPadding = this.context.getResources().getDimension(animationPaddingRes);
            return this;
        }

        @TargetApi(value=11)
        public Builder animationDuration(long animationDuration) {
            this.animationDuration = animationDuration;
            return this;
        }

        public Builder padding(float padding) {
            this.padding = padding;
            return this;
        }

        public Builder padding(@DimenRes int paddingRes) {
            this.padding = this.context.getResources().getDimension(paddingRes);
            return this;
        }

        public Builder margin(float margin) {
            this.margin = margin;
            return this;
        }

        public Builder margin(@DimenRes int marginRes) {
            this.margin = this.context.getResources().getDimension(marginRes);
            return this;
        }

        public Builder textColor(int textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder overlayWindowBackgroundColor(@ColorInt int overlayWindowBackgroundColor) {
            this.overlayWindowBackgroundColor = overlayWindowBackgroundColor;
            return this;
        }

        public Builder showArrow(boolean showArrow) {
            this.showArrow = showArrow;
            return this;
        }

        public Builder arrowDrawable(Drawable arrowDrawable) {
            this.arrowDrawable = arrowDrawable;
            return this;
        }

        public Builder arrowDrawable(@DrawableRes int drawableRes) {
            this.arrowDrawable = SimpleTooltipUtils.getDrawable(this.context, drawableRes);
            return this;
        }

        public Builder arrowColor(@ColorInt int arrowColor) {
            this.arrowColor = arrowColor;
            return this;
        }

        public Builder arrowHeight(float arrowHeight) {
            this.arrowHeight = arrowHeight;
            return this;
        }

        public Builder arrowWidth(float arrowWidth) {
            this.arrowWidth = arrowWidth;
            return this;
        }

        public Builder onDismissListener(OnDismissListener onDismissListener) {
            this.onDismissListener = onDismissListener;
            return this;
        }

        public Builder onShowListener(OnShowListener onShowListener) {
            this.onShowListener = onShowListener;
            return this;
        }

        public Builder focusable(boolean focusable) {
            this.focusable = focusable;
            return this;
        }

        public Builder highlightShape(int highlightShape) {
            this.highlightShape = highlightShape;
            return this;
        }

        public Builder cornerRadius(float radius) {
            this.cornerRadius = radius;
            return this;
        }

        public Builder overlayOffset(@Dimension float overlayOffset) {
            this.overlayOffset = overlayOffset;
            return this;
        }

        public Builder overlayMatchParent(boolean overlayMatchParent) {
            this.overlayMatchParent = overlayMatchParent;
            return this;
        }

        public Builder ignoreOverlay(boolean ignoreOverlay) {
            this.ignoreOverlay = ignoreOverlay;
            return this;
        }
    }

    public static interface OnShowListener {
        public void onShow(SimpleTooltip var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(SimpleTooltip var1);
    }
}

