/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.ListPopupWindow;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.PhotoPickerActivity;
import com.yongbeam.y_photopicker.util.photopicker.adapter.PhotoGridAdapter;
import com.yongbeam.y_photopicker.util.photopicker.adapter.PopupDirectoryListAdapter;
import com.yongbeam.y_photopicker.util.photopicker.entity.Photo;
import com.yongbeam.y_photopicker.util.photopicker.entity.PhotoDirectory;
import com.yongbeam.y_photopicker.util.photopicker.event.OnPhotoClickListener;
import com.yongbeam.y_photopicker.util.photopicker.fragment.ImagePagerFragment;
import com.yongbeam.y_photopicker.util.photopicker.utils.ImageCaptureManager;
import com.yongbeam.y_photopicker.util.photopicker.utils.MediaStoreHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PhotoPickerFragment
extends Fragment {
    private Context mContext = null;
    private Activity mActivity = null;
    private ImageCaptureManager captureManager;
    private PhotoGridAdapter photoGridAdapter;
    private PopupDirectoryListAdapter listAdapter;
    private List<PhotoDirectory> directories;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this.getActivity().getApplicationContext();
        this.mActivity = this.getActivity();
        this.directories = new ArrayList<PhotoDirectory>();
        this.captureManager = new ImageCaptureManager((Context)this.getActivity());
        Bundle mediaStoreArgs = new Bundle();
        if (this.getActivity() instanceof PhotoPickerActivity) {
            mediaStoreArgs.putBoolean("SHOW_GIF", ((PhotoPickerActivity)this.getActivity()).isShowGif());
        }
        MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new MediaStoreHelper.PhotosResultCallback(){

            @Override
            public void onResultCallback(List<PhotoDirectory> dirs) {
                PhotoPickerFragment.this.directories.clear();
                PhotoPickerFragment.this.directories.addAll(dirs);
                PhotoPickerFragment.this.photoGridAdapter.notifyDataSetChanged();
                PhotoPickerFragment.this.listAdapter.notifyDataSetChanged();
            }
        });
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.setRetainInstance(true);
        final View rootView = inflater.inflate(R.layout.util_fragment_photo_picker, container, false);
        this.photoGridAdapter = new PhotoGridAdapter((Context)this.getActivity(), this.directories, ((PhotoPickerActivity)this.getActivity()).isCheckBoxOnly);
        this.listAdapter = new PopupDirectoryListAdapter((Context)this.getActivity(), this.directories);
        RecyclerView recyclerView = (RecyclerView)rootView.findViewById(R.id.rv_photos);
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(((PhotoPickerActivity)this.getActivity()).maxGrideItemCount, 1);
        layoutManager.setGapStrategy(2);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        final Button btSwitchDirectory = (Button)rootView.findViewById(R.id.button);
        final ListPopupWindow listPopupWindow = new ListPopupWindow((Context)this.getActivity());
        listPopupWindow.setWidth(-1);
        listPopupWindow.setAnchorView((View)btSwitchDirectory);
        listPopupWindow.setAdapter((ListAdapter)this.listAdapter);
        listPopupWindow.setModal(true);
        listPopupWindow.setDropDownGravity(80);
        listPopupWindow.setAnimationStyle(R.style.Animation_AppCompat_DropDownUp);
        listPopupWindow.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.bg_popup_menu));
        listPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                listPopupWindow.dismiss();
                PhotoDirectory directory = (PhotoDirectory)PhotoPickerFragment.this.directories.get(position);
                btSwitchDirectory.setText((CharSequence)directory.getName());
                PhotoPickerFragment.this.photoGridAdapter.setCurrentDirectoryIndex(position);
                PhotoPickerFragment.this.photoGridAdapter.notifyDataSetChanged();
            }
        });
        this.photoGridAdapter.setOnPhotoClickListener(new OnPhotoClickListener(){

            @Override
            public void onClick(View v, int position, boolean showCamera) {
                int index = showCamera ? position - 1 : position;
                List<String> photos = PhotoPickerFragment.this.photoGridAdapter.getCurrentPhotoPaths();
                int[] screenLocation = new int[2];
                v.getLocationOnScreen(screenLocation);
                ImagePagerFragment imagePagerFragment = ImagePagerFragment.newInstance(photos, index, screenLocation, v.getWidth(), v.getHeight());
                ((PhotoPickerActivity)PhotoPickerFragment.this.getActivity()).addImagePagerFragment(imagePagerFragment);
            }
        });
        this.photoGridAdapter.setOnCameraClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    Intent intent = PhotoPickerFragment.this.captureManager.dispatchTakePictureIntent();
                    PhotoPickerFragment.this.startActivityForResult(intent, 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        btSwitchDirectory.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listPopupWindow.isShowing()) {
                    listPopupWindow.dismiss();
                } else if (!PhotoPickerFragment.this.getActivity().isFinishing()) {
                    listPopupWindow.setHeight(Math.round((float)rootView.getHeight() * 0.8f));
                    listPopupWindow.show();
                }
            }
        });
        return rootView;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)"TAG", (String)("\uc0ac\uc9c4\ucd2c\uc601 \uc644\ub8cc" + requestCode));
        Log.d((String)"TAG", (String)("\uc0ac\uc9c4\ucd2c\uc601 \uc644\ub8cc " + resultCode));
        if (requestCode == 1 && resultCode == -1) {
            Log.d((String)"TAG", (String)"\ud638\ucd9c");
            this.captureManager.galleryAddPic();
            if (this.directories.size() > 0) {
                String path = this.captureManager.getCurrentPhotoPath();
                PhotoDirectory directory = this.directories.get(0);
                directory.getPhotos().add(0, new Photo(path.hashCode(), path));
                directory.setCoverPath(path);
                String temp_patch = this.getLastPhotoPath();
                temp_patch = temp_patch.replace(".jpg", "");
                String newFileName = new File(path).getName();
                if (path.contains(temp_patch)) {
                    // empty if block
                }
                this.photoGridAdapter.notifyDataSetChanged();
            }
        }
    }

    public PhotoGridAdapter getPhotoGridAdapter() {
        return this.photoGridAdapter;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.captureManager.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        this.captureManager.onRestoreInstanceState(savedInstanceState);
        super.onViewStateRestored(savedInstanceState);
    }

    public ArrayList<String> getSelectedPhotoPaths() {
        return this.photoGridAdapter.getSelectedPhotoPaths();
    }

    public String getLastPhotoPath() {
        String[] IMAGE_PROJECTION = new String[]{"_data", "_data"};
        Uri uriImages = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        String cameraPath = "'";
        String FileName = "";
        try {
            Cursor cursorImages = this.mActivity.getContentResolver().query(uriImages, IMAGE_PROJECTION, null, null, null);
            if (cursorImages != null && cursorImages.moveToLast()) {
                cameraPath = cursorImages.getString(0);
                cursorImages.close();
                FileName = new File(cameraPath).getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileName;
    }
}

