/*
 * Decompiled with CFR 0.152.
 */
package com.yongbeam.y_photopicker.util.photopicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.yongbeam.y_photopicker.R;
import com.yongbeam.y_photopicker.util.photopicker.entity.Photo;
import com.yongbeam.y_photopicker.util.photopicker.event.OnItemCheckListener;
import com.yongbeam.y_photopicker.util.photopicker.fragment.ImagePagerFragment;
import com.yongbeam.y_photopicker.util.photopicker.fragment.PhotoPickerFragment;
import java.util.ArrayList;
import java.util.List;

public class PhotoPickerActivity
extends AppCompatActivity {
    private final int MY_PERMISSIONS_REQUEST_READ_EXTERNAL_STORAGE = 7;
    private final int MY_PERMISSIONS_REQUEST_CAMERA = 8;
    private PhotoPickerFragment pickerFragment;
    private ImagePagerFragment imagePagerFragment;
    public static final String EXTRA_MAX_COUNT = "MAX_COUNT";
    public static final String EXTRA_SHOW_CAMERA = "SHOW_CAMERA";
    public static final String EXTRA_SHOW_GIF = "SHOW_GIF";
    public static final String EXTRA_CHECK_BOX_ONLY = "CHECK_BOX_ONLY";
    public static final String KEY_SELECTED_PHOTOS = "SELECTED_PHOTOS";
    public static final String EXTRA_MAX_GRIDE_ITEM_COUNT = "MAX_GRIDE_IMAGE_COUNT";
    private MenuItem menuDoneItem;
    public static final int DEFAULT_MAX_COUNT = 9;
    public static final int DEFAULT_MAX_GRIDE_ITEM_COUNT = 3;
    private int maxCount = 9;
    public int maxGrideItemCount = 3;
    public boolean isCheckBoxOnly = false;
    private boolean menuIsInflated = false;
    private boolean showGif = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isREAD_EXTERNAL_STORAGE_Permission();
    }

    private void isREAD_EXTERNAL_STORAGE_Permission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.READ_EXTERNAL_STORAGE")) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)7);
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)7);
            }
        } else {
            this.isCAMERA_Permission();
        }
    }

    private void isCAMERA_Permission() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.CAMERA")) {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)8);
            } else {
                ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)8);
            }
        } else {
            this.initLayout();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 7: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.isCAMERA_Permission();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"You do not have read permissions.", (int)1).show();
                    this.finish();
                }
                return;
            }
            case 8: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.initLayout();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"There is no camera permissions.", (int)1).show();
                }
                return;
            }
        }
    }

    private void initLayout() {
        boolean showCamera = this.getIntent().getBooleanExtra(EXTRA_SHOW_CAMERA, true);
        boolean showGif = this.getIntent().getBooleanExtra(EXTRA_SHOW_GIF, false);
        this.isCheckBoxOnly = this.getIntent().getBooleanExtra(EXTRA_CHECK_BOX_ONLY, false);
        this.maxGrideItemCount = this.getIntent().getIntExtra(EXTRA_MAX_GRIDE_ITEM_COUNT, 3);
        this.setShowGif(showGif);
        this.setContentView(R.layout.util_activity_photo_picker);
        Toolbar mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        mToolbar.setTitle(R.string.y_photopicker_image_select_title);
        this.setSupportActionBar(mToolbar);
        ActionBar actionBar = this.getSupportActionBar();
        assert (actionBar != null);
        actionBar.setDisplayHomeAsUpEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            actionBar.setElevation(25.0f);
        }
        this.maxCount = this.getIntent().getIntExtra(EXTRA_MAX_COUNT, 9);
        this.pickerFragment = (PhotoPickerFragment)this.getSupportFragmentManager().findFragmentById(R.id.photoPickerFragment);
        this.pickerFragment.getPhotoGridAdapter().setShowCamera(showCamera);
        this.pickerFragment.getPhotoGridAdapter().setOnItemCheckListener(new OnItemCheckListener(){

            @Override
            public boolean OnItemCheck(int position, Photo photo, boolean isCheck, int selectedItemCount) {
                int total = selectedItemCount + (isCheck ? -1 : 1);
                PhotoPickerActivity.this.menuDoneItem.setEnabled(total > 0);
                if (PhotoPickerActivity.this.maxCount <= 1) {
                    List<Photo> photos = PhotoPickerActivity.this.pickerFragment.getPhotoGridAdapter().getSelectedPhotos();
                    if (!photos.contains(photo)) {
                        photos.clear();
                        PhotoPickerActivity.this.pickerFragment.getPhotoGridAdapter().notifyDataSetChanged();
                    }
                    return true;
                }
                if (total > PhotoPickerActivity.this.maxCount) {
                    Toast.makeText((Context)PhotoPickerActivity.this.getActivity(), (CharSequence)PhotoPickerActivity.this.getString(R.string.y_photopicker_over_max_count_tips, new Object[]{PhotoPickerActivity.this.maxCount}), (int)1).show();
                    return false;
                }
                PhotoPickerActivity.this.menuDoneItem.setTitle((CharSequence)PhotoPickerActivity.this.getString(R.string.y_photopicker_done_with_count, new Object[]{total, PhotoPickerActivity.this.maxCount}));
                return true;
            }
        });
    }

    public void onBackPressed() {
        if (this.imagePagerFragment != null && this.imagePagerFragment.isVisible()) {
            this.imagePagerFragment.runExitAnimation(new Runnable(){

                @Override
                public void run() {
                    if (PhotoPickerActivity.this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
                        PhotoPickerActivity.this.getSupportFragmentManager().popBackStack();
                    }
                }
            });
        } else {
            super.onBackPressed();
        }
    }

    public void addImagePagerFragment(ImagePagerFragment imagePagerFragment) {
        this.imagePagerFragment = imagePagerFragment;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.imagePagerFragment).addToBackStack(null).commit();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (!this.menuIsInflated) {
            this.getMenuInflater().inflate(R.menu.menu_picker, menu2);
            this.menuDoneItem = menu2.findItem(R.id.done);
            this.menuDoneItem.setEnabled(false);
            this.menuIsInflated = true;
            return true;
        }
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            super.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.done) {
            Intent intent = new Intent();
            ArrayList<String> selectedPhotos = this.pickerFragment.getPhotoGridAdapter().getSelectedPhotoPaths();
            intent.putStringArrayListExtra(KEY_SELECTED_PHOTOS, selectedPhotos);
            this.setResult(-1, intent);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public PhotoPickerActivity getActivity() {
        return this;
    }

    public boolean isShowGif() {
        return this.showGif;
    }

    public void setShowGif(boolean showGif) {
        this.showGif = showGif;
    }
}

