/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.repackaged.org.jdom2.adapters;

import com.github.dnault.xmlpatch.repackaged.org.jdom2.DocType;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.JDOMException;
import com.github.dnault.xmlpatch.repackaged.org.jdom2.adapters.DOMAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import shadow.org.w3c.dom.DOMImplementation;
import shadow.org.w3c.dom.Document;
import shadow.org.w3c.dom.DocumentType;
import shadow.org.w3c.dom.Element;
import shadow.org.w3c.dom.Node;

public abstract class AbstractDOMAdapter
implements DOMAdapter {
    public Document createDocument(DocType doctype) throws JDOMException {
        if (doctype == null) {
            return this.createDocument();
        }
        DOMImplementation domImpl = this.createDocument().getImplementation();
        DocumentType domDocType = domImpl.createDocumentType(doctype.getElementName(), doctype.getPublicID(), doctype.getSystemID());
        this.setInternalSubset(domDocType, doctype.getInternalSubset());
        Document ret = domImpl.createDocument("http://temporary", doctype.getElementName(), domDocType);
        Element root = ret.getDocumentElement();
        if (root != null) {
            ret.removeChild((Node)root);
        }
        return ret;
    }

    protected void setInternalSubset(DocumentType dt, String s) {
        if (dt == null || s == null) {
            return;
        }
        try {
            Class<?> dtclass = dt.getClass();
            Method setInternalSubset = dtclass.getMethod("setInternalSubset", String.class);
            setInternalSubset.invoke((Object)dt, s);
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

