/*
 * Decompiled with CFR 0.152.
 */
package com.github.dnault.xmlpatch.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractPatchTask
extends Task {
    private String src;
    private String dest;
    private String patch;
    private String inlinePatch;

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = new File(src).getAbsolutePath();
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = new File(dest).getAbsolutePath();
    }

    public String getPatch() {
        return this.patch;
    }

    public void setPatch(String patch) {
        this.patch = patch;
    }

    public String getInlinePatch() {
        return this.inlinePatch;
    }

    public void addText(String text) {
        this.inlinePatch = this.getProject().replaceProperties(text);
    }

    protected void checkArgs() {
        if (this.src == null) {
            throw new BuildException("missing 'src' attribute");
        }
        if (this.patch == null && this.inlinePatch == null) {
            throw new BuildException("missing 'patch' attribute or nested text");
        }
        if (this.patch != null && this.inlinePatch != null) {
            throw new BuildException("must not provide both 'patch' attribute and nested text");
        }
        if (this.dest == null) {
            this.dest = this.src;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.checkArgs();
        File tempFile = null;
        try {
            if (this.getInlinePatch() != null) {
                try {
                    tempFile = File.createTempFile("inline-patch-", ".xml");
                    this.setPatch(tempFile.getAbsolutePath());
                    try (FileOutputStream os = new FileOutputStream(tempFile);){
                        ((OutputStream)os).write(this.getInlinePatch().getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
            try {
                this.log("Applying XML patch");
                this.log("      src: " + this.getSrc());
                this.log("    patch: " + this.getPatch());
                this.log("     dest: " + this.getDest());
                this.doPatch();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (tempFile != null && !tempFile.delete()) {
                this.log("Failed to delete temp file for inline XML patch: " + tempFile.getAbsolutePath());
            }
        }
    }

    protected abstract void doPatch() throws Exception;
}

