/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview;

import android.support.annotation.NonNull;
import android.view.DragEvent;
import android.view.View;

class DismissibleOnDragListener
implements View.OnDragListener {
    @NonNull
    private final OnDropListener onDropListener;

    DismissibleOnDragListener(@NonNull OnDropListener onDropListener) {
        this.onDropListener = onDropListener;
    }

    public boolean onDrag(View v, DragEvent event) {
        switch (event.getAction()) {
            case 1: {
                this.onDropListener.onDragStarted();
                return true;
            }
            case 5: {
                return true;
            }
            case 2: {
                this.onDropListener.onDragLocation(event.getX(), event.getY());
                return true;
            }
            case 6: {
                return true;
            }
            case 3: {
                this.onDropListener.onDrop();
                return true;
            }
            case 4: {
                this.onDropListener.onDragEnded();
                return true;
            }
        }
        return false;
    }

    static abstract class OnDropListener {
        OnDropListener() {
        }

        abstract void onDragStarted();

        abstract void onDrop();

        abstract void onDragEnded();

        abstract void onDragLocation(float var1, float var2);
    }
}

