/*
 * Decompiled with CFR 0.152.
 */
package com.dmallcott.dismissibleimageview;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;

class DismissibleDragShadowBuilder
extends View.DragShadowBuilder {
    private final Drawable shadow;
    private final Point offset;

    DismissibleDragShadowBuilder(ImageView imageView, Point offset) {
        super((View)imageView);
        this.offset = offset;
        this.shadow = new ColorDrawable(-3355444);
    }

    public void onProvideShadowMetrics(Point size, Point touch) {
        int width = this.getView().getWidth();
        int height = this.getView().getHeight();
        this.shadow.setBounds(0, 0, width, height);
        size.set(width, height);
        touch.set(this.offset.x, this.offset.y);
    }

    public void onDrawShadow(Canvas canvas) {
        this.shadow.draw(canvas);
        this.getView().draw(canvas);
    }
}

