/*
 * Decompiled with CFR 0.152.
 */
package me.dkzwm.widget.fet;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.EditText;
import java.util.ArrayList;
import java.util.List;
import me.dkzwm.widget.fet.R;

public class FormattedEditText
extends EditText {
    public static final int MODE_SIMPLE = 0;
    public static final int MODE_COMPLEX = 1;
    private static final String DEFAULT_PLACE_HOLDER = " ";
    private static final String DEFAULT_MARK = "*";
    private int[] mPlaceHoldersPos;
    private String[] mPlaceHolders;
    private String mMark;
    private int mMode = 0;
    private List<TextWatcher> mWatchers;
    private boolean mHasBeenFormatted = false;
    private StringBuilder mTextBuilder = new StringBuilder();

    public FormattedEditText(Context context) {
        this(context, null, 16842862);
    }

    public FormattedEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public FormattedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (!FormattedEditText.this.mHasBeenFormatted && (FormattedEditText.this.mPlaceHoldersPos == null || s.length() > 0 && s.length() - count == 0)) {
                    FormattedEditText.this.sendBeforeTextChanged(s, start, count, after);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (FormattedEditText.this.mPlaceHoldersPos == null || s.length() == 0) {
                    FormattedEditText.this.sendOnTextChanged(s, start, before, count);
                    return;
                }
                if (!FormattedEditText.this.mHasBeenFormatted) {
                    FormattedEditText.this.formatText(s, start, before, count);
                }
            }

            public void afterTextChanged(Editable s) {
                if (FormattedEditText.this.mPlaceHoldersPos == null || s.length() == 0) {
                    FormattedEditText.this.sendAfterTextChanged(s);
                }
                if (s.length() == 0 && FormattedEditText.this.mTextBuilder.length() != 0) {
                    FormattedEditText.this.mTextBuilder.setLength(0);
                }
            }
        };
        super.addTextChangedListener(textWatcher);
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FormattedEditText, defStyleAttr, 0);
            this.mMark = ta.getString(R.styleable.FormattedEditText_fet_mark);
            int mode = ta.getInt(R.styleable.FormattedEditText_fet_mode, 0);
            this.setMode(mode);
            String formatStyle = ta.getString(R.styleable.FormattedEditText_fet_formatStyle);
            this.setFormatStyle(formatStyle);
            if (this.mMode == 0) {
                String placeHolder = ta.getString(R.styleable.FormattedEditText_fet_placeholder);
                if (placeHolder != null) {
                    if (placeHolder.length() > 1) {
                        throw new IllegalArgumentException("PlaceHolder only can support one char");
                    }
                    this.setPlaceholder(placeHolder);
                } else {
                    this.mPlaceHolders = new String[1];
                    this.mPlaceHolders[0] = DEFAULT_PLACE_HOLDER;
                }
            }
            ta.recycle();
        }
        if (this.getText().length() > 0) {
            this.formatText(this.getText().toString(), 0, 0, this.getText().length());
        }
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mWatchers == null) {
            this.mWatchers = new ArrayList<TextWatcher>();
        }
        this.mWatchers.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mWatchers != null && (i = this.mWatchers.indexOf(watcher)) >= 0) {
            this.mWatchers.remove(i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFormatStyle(String style) {
        if (style != null) {
            if (this.mMode == 0) {
                boolean isNumeric = FormattedEditText.isNumeric(style);
                if (!isNumeric) throw new IllegalArgumentException("Format style must be numeric");
                this.mPlaceHoldersPos = new int[style.length()];
                this.mPlaceHoldersPos[0] = Character.getNumericValue(style.charAt(0));
                for (int i = 1; i < style.length(); ++i) {
                    int number = Character.getNumericValue(style.charAt(i));
                    this.mPlaceHoldersPos[i] = this.mPlaceHoldersPos[i - 1] + 1 + number;
                }
                return;
            } else {
                if (!style.contains(this.mMark)) {
                    throw new IllegalArgumentException("Format style must be have Mark strings");
                }
                String[] tempHolders = new String[style.length()];
                int[] tempHoldersPos = new int[style.length()];
                int realCount = 0;
                for (int i = 0; i < style.length(); ++i) {
                    String sub = style.substring(i, i + 1);
                    if (sub.equals(this.mMark)) continue;
                    tempHolders[realCount] = sub;
                    tempHoldersPos[realCount] = i;
                    ++realCount;
                }
                this.mPlaceHoldersPos = new int[realCount];
                System.arraycopy(tempHoldersPos, 0, this.mPlaceHoldersPos, 0, realCount);
                this.mPlaceHolders = new String[realCount];
                System.arraycopy(tempHolders, 0, this.mPlaceHolders, 0, realCount);
            }
            return;
        } else {
            this.mPlaceHolders = null;
            this.mPlaceHoldersPos = null;
        }
    }

    public void setMode(int mode) {
        if (this.mMode != mode) {
            String originalText = this.getText().toString();
            this.mMode = mode;
            if (this.mMode == 1 && TextUtils.isEmpty((CharSequence)this.mMark)) {
                this.mMark = DEFAULT_MARK;
            }
            if (!TextUtils.isEmpty((CharSequence)originalText)) {
                this.setText("");
                this.setText(originalText);
            }
        }
    }

    public void setMark(@NonNull String mark) {
        if (mark.length() > 1) {
            throw new IllegalArgumentException("Mark only supports length one strings");
        }
        this.mMark = mark;
    }

    public void setPlaceholder(@NonNull String holder) {
        if (this.mMode == 0) {
            if (holder.length() > 1) {
                throw new IllegalArgumentException("Placeholder only supports length one strings");
            }
        } else {
            throw new IllegalArgumentException("Placeholder only supports mode is MODE_SIMPLE");
        }
        this.mPlaceHolders = new String[1];
        this.mPlaceHolders[0] = holder;
    }

    private void sendBeforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).beforeTextChanged(s, start, count, after);
            }
        }
    }

    private void sendOnTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).onTextChanged(s, start, before, count);
            }
        }
    }

    private void sendAfterTextChanged(Editable s) {
        if (this.mWatchers != null) {
            List<TextWatcher> list = this.mWatchers;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                list.get(i).afterTextChanged(s);
            }
        }
    }

    private void formatText(CharSequence s, int start, int before, int count) {
        if (before > 0) {
            this.formatTextWhenDelete(s, start);
        } else if (count > 0) {
            this.formatTextWhenAppend(s, start, count);
        }
    }

    private void formatTextWhenDelete(CharSequence s, int start) {
        int i;
        String lastText = this.mTextBuilder.toString();
        if (start < s.length()) {
            int startPos = this.mPlaceHoldersPos.length - 1;
            for (i = 0; i < this.mPlaceHoldersPos.length; ++i) {
                if (start - 1 > this.mPlaceHoldersPos[i]) continue;
                startPos = i - 1;
                break;
            }
            if (startPos < 0) {
                this.mTextBuilder.delete(0, this.mTextBuilder.length());
                this.formatTextNoCursor(s.toString(), 0, 0, 0);
            } else {
                this.mTextBuilder.delete(this.mPlaceHoldersPos[startPos], this.mTextBuilder.length());
                this.formatTextNoCursor(s.toString(), this.mPlaceHoldersPos[startPos], 0, startPos);
            }
            block1: for (i = start; i > 0; --i) {
                String sub = this.mTextBuilder.substring(i - 1, i);
                for (String placeholder : this.mPlaceHolders) {
                    if (!sub.equals(placeholder)) continue;
                    --start;
                    continue block1;
                }
                break;
            }
        } else {
            int length;
            this.mTextBuilder.delete(start, this.mTextBuilder.length());
            block3: for (i = length = this.mTextBuilder.length(); i > 0; --i) {
                String sub = this.mTextBuilder.substring(i - 1, i);
                for (String placeholder : this.mPlaceHolders) {
                    if (!sub.equals(placeholder)) {
                        continue;
                    }
                    this.mTextBuilder.delete(i - 1, i);
                    continue block3;
                }
                break;
            }
        }
        this.mHasBeenFormatted = true;
        String text = this.mTextBuilder.toString();
        int realCount = lastText.length() - text.length();
        this.sendBeforeTextChanged(lastText, start, realCount, 0);
        this.setText(text);
        this.mHasBeenFormatted = false;
        if (start > text.length()) {
            this.setSelection(text.length());
        } else {
            this.setSelection(start);
        }
        this.sendOnTextChanged(text, start, realCount, 0);
        this.sendAfterTextChanged(this.getText());
    }

    private void formatTextWhenAppend(CharSequence s, int start, int count) {
        int tailLength;
        String lastText = this.mTextBuilder.toString();
        int startPos = 0;
        for (int i = 0; i < this.mPlaceHoldersPos.length; ++i) {
            if (start > this.mPlaceHoldersPos[i]) continue;
            startPos = i;
            break;
        }
        if ((tailLength = this.mTextBuilder.length() - start) > 0) {
            this.mTextBuilder.delete(start, this.mTextBuilder.length());
        }
        int realPos = this.formatTextNoCursor(s.toString(), start, count, startPos);
        this.mHasBeenFormatted = true;
        String text = this.mTextBuilder.toString();
        this.sendBeforeTextChanged(lastText, start, 0, realPos - start);
        this.setText(text);
        this.mHasBeenFormatted = false;
        this.setSelection(realPos);
        this.sendOnTextChanged(text, start, 0, realPos - start);
        this.sendAfterTextChanged(this.getText());
    }

    private int formatTextNoCursor(String text, int start, int count, int position) {
        int length = text.length();
        int afterAppendStart = 0;
        int lastI = -1;
        for (int i = start; i < length; ++i) {
            boolean found = false;
            String sub = text.substring(i, i + 1);
            for (String placeholder : this.mPlaceHolders) {
                if (!sub.equals(placeholder)) continue;
                found = true;
                break;
            }
            if (found) {
                if (count > 0 && i >= start && count > 0 && lastI != i && --count == 0) {
                    afterAppendStart = this.mTextBuilder.length();
                }
                lastI = i;
                continue;
            }
            if (position >= this.mPlaceHoldersPos.length || this.mTextBuilder.length() != this.mPlaceHoldersPos[position]) {
                this.mTextBuilder.append(sub);
                if (count > 0 && i >= start && count > 0 && lastI != i && --count == 0) {
                    afterAppendStart = this.mTextBuilder.length();
                }
                if (position < this.mPlaceHoldersPos.length && this.mTextBuilder.length() > this.mPlaceHoldersPos[position]) {
                    ++position;
                }
            } else {
                if (this.mMode == 0) {
                    this.mTextBuilder.append(this.mPlaceHolders[0]);
                } else {
                    this.mTextBuilder.append(this.mPlaceHolders[position]);
                }
                ++position;
            }
            lastI = --i;
        }
        return afterAppendStart;
    }
}

