/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging.interceptors;

import com.dkorobtsov.logging.ClientPrintingExecutor;
import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.RequestDetails;
import com.dkorobtsov.logging.ResponseDetails;
import com.dkorobtsov.logging.TextUtils;
import com.dkorobtsov.logging.converters.ToOkhttp3Converter;
import com.dkorobtsov.logging.converters.ToOkhttpConverter;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.RequestBody;

public class OkhttpLoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private final LoggerConfig loggerConfig;

    public OkhttpLoggingInterceptor(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
        this.isDebug = loggerConfig.isDebug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        okhttp3.Request requestDetails = new RequestDetails.Builder().from(request).build();
        if (!this.isDebug || this.loggerConfig.level == Level.NONE) {
            return chain.proceed(request);
        }
        RequestBody requestBody = requestDetails.body();
        String requestSubtype = null;
        if (requestBody != null && requestBody.contentType() != null) {
            requestSubtype = Objects.requireNonNull(requestBody.contentType()).subtype();
        }
        if (TextUtils.isFileRequest(requestSubtype)) {
            ClientPrintingExecutor.printFileRequest(requestDetails, this.loggerConfig);
        } else {
            ClientPrintingExecutor.printJsonRequest(requestDetails, this.loggerConfig);
        }
        long requestStartTime = System.nanoTime();
        Response response = chain.proceed(request);
        long responseTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - requestStartTime);
        String subtype = null;
        if (Objects.requireNonNull(response.body()).contentType() != null) {
            subtype = Objects.requireNonNull(response.body().contentType()).subtype();
        }
        ResponseDetails responseDetails = ResponseDetails.from(requestDetails, ToOkhttp3Converter.convertOkhttpResponseTo3(response), responseTime, TextUtils.isFileRequest(subtype));
        if (TextUtils.isFileRequest(subtype)) {
            ClientPrintingExecutor.printFileResponse(responseDetails, this.loggerConfig);
            return response;
        }
        ClientPrintingExecutor.printJsonResponse(responseDetails, this.loggerConfig);
        okhttp3.MediaType okhttp3MediaType = responseDetails.contentType;
        MediaType mediaType = ToOkhttpConverter.convertOkhttp3MediaType(okhttp3MediaType);
        ResponseBody body = ResponseBody.create((MediaType)mediaType, (String)responseDetails.originalBody);
        return response.newBuilder().body(body).build();
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }
}

