/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging.interceptors;

import com.dkorobtsov.logging.ClientPrintingExecutor;
import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.ResponseDetails;
import com.dkorobtsov.logging.TextUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class Okhttp3LoggingInterceptor
implements Interceptor {
    private final boolean isDebug;
    private final LoggerConfig loggerConfig;

    public Okhttp3LoggingInterceptor(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
        this.isDebug = loggerConfig.isDebug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (!this.isDebug || this.loggerConfig.level == Level.NONE) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        String requestSubtype = null;
        if (requestBody != null && requestBody.contentType() != null) {
            requestSubtype = Objects.requireNonNull(requestBody.contentType()).subtype();
        }
        if (TextUtils.isFileRequest(requestSubtype)) {
            ClientPrintingExecutor.printFileRequest(request, this.loggerConfig);
        } else {
            ClientPrintingExecutor.printJsonRequest(request, this.loggerConfig);
        }
        long startTime = System.nanoTime();
        Response response = chain.proceed(request);
        long responseTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        String subtype = null;
        if (Objects.requireNonNull(response.body()).contentType() != null) {
            subtype = Objects.requireNonNull(response.body().contentType()).subtype();
        }
        ResponseDetails responseDetails = ResponseDetails.from(request, response, responseTime, TextUtils.isFileRequest(subtype));
        if (TextUtils.isFileRequest(subtype)) {
            ClientPrintingExecutor.printFileResponse(responseDetails, this.loggerConfig);
            return response;
        }
        ClientPrintingExecutor.printJsonResponse(responseDetails, this.loggerConfig);
        ResponseBody body = ResponseBody.create((MediaType)responseDetails.contentType, (String)responseDetails.originalBody);
        return response.newBuilder().body(body).build();
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }
}

