/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging.interceptors;

import com.dkorobtsov.logging.ClientPrintingExecutor;
import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.RequestDetails;
import com.dkorobtsov.logging.TextUtils;
import java.util.Objects;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final boolean isDebug;
    private final LoggerConfig loggerConfig;

    public ApacheHttpRequestInterceptor(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
        this.isDebug = loggerConfig.isDebug;
    }

    public void process(HttpRequest request, HttpContext context) {
        if (this.isDebug && this.loggerConfig.level != Level.NONE) {
            Request requestDetails = new RequestDetails.Builder().from(request).build();
            RequestBody requestBody = requestDetails.body();
            String requestSubtype = null;
            if (requestBody != null && requestBody.contentType() != null) {
                requestSubtype = Objects.requireNonNull(requestBody.contentType()).subtype();
            }
            if (TextUtils.isFileRequest(requestSubtype)) {
                ClientPrintingExecutor.printFileRequest(requestDetails, this.loggerConfig);
            } else {
                ClientPrintingExecutor.printJsonRequest(requestDetails, this.loggerConfig);
            }
        }
    }

    public LoggerConfig loggerConfig() {
        return this.loggerConfig;
    }
}

