/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging.converters;

import com.squareup.okhttp.CacheControl;
import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.internal.http.HttpMethod;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.CacheControl;
import okhttp3.CipherSuite;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class ToOkhttp3Converter {
    private static final Logger logger = Logger.getLogger(ToOkhttp3Converter.class.getName());
    private static final String APPLICATION_JSON = "application/json";

    private ToOkhttp3Converter() {
    }

    private static okhttp3.MediaType convertOkhttpMediaTypeTo3(MediaType okhttpMediaType) {
        return okhttpMediaType == null ? okhttp3.MediaType.parse((String)"") : okhttp3.MediaType.parse((String)okhttpMediaType.toString());
    }

    public static RequestBody convertOkhttpRequestBodyTo3(com.squareup.okhttp.Request request) {
        okhttp3.MediaType contentType = request.body() == null ? okhttp3.MediaType.parse((String)"") : ToOkhttp3Converter.convertOkhttpMediaTypeTo3(request.body().contentType());
        try {
            com.squareup.okhttp.Request requestCopy = request.newBuilder().build();
            String requestBodyString = "";
            if (requestCopy.body() != null) {
                Buffer buffer = new Buffer();
                requestCopy.body().writeTo((BufferedSink)buffer);
                requestBodyString = buffer.readUtf8();
            }
            return RequestBody.create((okhttp3.MediaType)contentType, (String)requestBodyString);
        }
        catch (IOException e) {
            return RequestBody.create((okhttp3.MediaType)contentType, (String)"[LoggingInterceptorError] : could not parse request body");
        }
    }

    public static RequestBody convertApacheHttpRequestBodyTo3(HttpRequest request) {
        HttpEntity entity;
        HttpRequest original;
        if (request instanceof HttpRequestWrapper && (original = ((HttpRequestWrapper)request).getOriginal()) instanceof HttpEntityEnclosingRequestBase && (entity = ((HttpEntityEnclosingRequestBase)original).getEntity()) != null) {
            String requestBodyString;
            try {
                requestBodyString = ToOkhttp3Converter.readApacheHttpEntity(entity);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)APPLICATION_JSON), (String)"[LoggingInterceptorError] : could not parse request body");
            }
            HttpEntity newEntity = ToOkhttp3Converter.recreateHttpEntityFromString(requestBodyString, entity);
            ((HttpEntityEnclosingRequestBase)((HttpRequestWrapper)request).getOriginal()).setEntity(newEntity);
            Header contentTypeHeader = Arrays.stream(((HttpRequestWrapper)request).getOriginal().getAllHeaders()).filter(header -> header.getName().equals("Content-Type")).findFirst().orElse((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
            return RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)contentTypeHeader.getValue()), (String)requestBodyString);
        }
        return RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)APPLICATION_JSON), (String)"");
    }

    public static okhttp3.ResponseBody convertApacheHttpResponseBodyTo3(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String requestBodyString;
            try {
                requestBodyString = ToOkhttp3Converter.readApacheHttpEntity(entity);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return okhttp3.ResponseBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)APPLICATION_JSON), (String)"[LoggingInterceptorError] : could not parse response body");
            }
            Header contentType = response.getEntity().getContentType();
            String contentTypeString = contentType == null ? "" : String.format("%s, %s", contentType.getName(), contentType.getValue());
            HttpEntity newEntity = ToOkhttp3Converter.recreateHttpEntityFromString(requestBodyString, entity);
            response.setEntity(newEntity);
            return okhttp3.ResponseBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)contentTypeString), (String)requestBodyString);
        }
        return okhttp3.ResponseBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)APPLICATION_JSON), (String)"");
    }

    private static String readApacheHttpEntity(HttpEntity entity) throws IOException {
        if (entity != null) {
            StringBuilder textBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), Charset.forName(StandardCharsets.UTF_8.name())));){
                int c;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
                String string = textBuilder.toString();
                return string;
            }
        }
        return "";
    }

    private static HttpEntity recreateHttpEntityFromString(String httpEntityContent, HttpEntity entity) {
        Header contentType = entity.getContentType();
        String contentTypeString = contentType == null ? "Content-Type=application/json" : String.format("%s=%s", contentType.getName(), contentType.getValue());
        Header contentEncodingHeader = entity.getContentEncoding();
        EntityBuilder entityBuilder = EntityBuilder.create().setContentType(ContentType.parse((String)contentTypeString)).setStream((InputStream)new ByteArrayInputStream(httpEntityContent.getBytes()));
        if (contentEncodingHeader != null) {
            return entityBuilder.setContentEncoding(String.format("%s/%s", contentEncodingHeader.getName(), contentEncodingHeader.getValue())).build();
        }
        return entityBuilder.build();
    }

    public static okhttp3.CacheControl convertOkhttpCacheControlTo3(CacheControl cacheControl) {
        return new CacheControl.Builder().maxAge(cacheControl.maxAgeSeconds() == -1 ? 0 : cacheControl.maxAgeSeconds(), TimeUnit.SECONDS).maxStale(cacheControl.maxStaleSeconds() == -1 ? 0 : cacheControl.maxStaleSeconds(), TimeUnit.SECONDS).minFresh(cacheControl.minFreshSeconds() == -1 ? 9 : cacheControl.minFreshSeconds(), TimeUnit.SECONDS).build();
    }

    private static Request convertOkhttpRequestTo3(com.squareup.okhttp.Request request) {
        Request.Builder builder = new Request.Builder();
        builder.url(request.url());
        Map headersMap = request.headers().toMultimap();
        headersMap.forEach((name, values) -> builder.addHeader(name, String.join((CharSequence)";", values)));
        if (HttpMethod.permitsRequestBody((String)request.method())) {
            builder.method(request.method(), ToOkhttp3Converter.convertOkhttpRequestBodyTo3(request));
        } else {
            builder.method(request.method(), null);
        }
        builder.tag(request.tag());
        builder.cacheControl(ToOkhttp3Converter.convertOkhttpCacheControlTo3(request.cacheControl()));
        return builder.build();
    }

    private static okhttp3.Handshake convertOkhttpHandshakeTo3(Handshake handshake) {
        if (handshake == null) {
            return null;
        }
        String cipherSuite = handshake.cipherSuite();
        List peerCertificates = handshake.peerCertificates();
        List localCertificates = handshake.localCertificates();
        return okhttp3.Handshake.get((TlsVersion)TlsVersion.SSL_3_0, (CipherSuite)CipherSuite.forJavaName((String)cipherSuite), (List)peerCertificates, (List)localCertificates);
    }

    private static okhttp3.Headers convertOkhttpHeadersTo3(Headers headers) {
        Headers.Builder headersBuilder = new Headers.Builder();
        headers.names().forEach(name -> headersBuilder.add(name, headers.get(name)));
        return headersBuilder.build();
    }

    private static okhttp3.ResponseBody convertOkhttpResponseBodyTo3(ResponseBody responseBody) {
        if (responseBody == null) {
            return null;
        }
        MediaType mediaType = responseBody.contentType();
        String responseBodyString = "";
        try {
            responseBodyString = new String(responseBody.bytes(), Charset.defaultCharset());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return okhttp3.ResponseBody.create((okhttp3.MediaType)ToOkhttp3Converter.convertOkhttpMediaTypeTo3(mediaType), (String)responseBodyString);
    }

    private static okhttp3.Protocol convertOkhttpProtocolTo3(Protocol protocol) {
        switch (protocol) {
            case HTTP_1_0: {
                return okhttp3.Protocol.HTTP_1_0;
            }
            case HTTP_1_1: {
                return okhttp3.Protocol.HTTP_1_1;
            }
            case HTTP_2: {
                return okhttp3.Protocol.HTTP_2;
            }
        }
        return okhttp3.Protocol.HTTP_1_1;
    }

    private static okhttp3.Response convertBaseOkhttpResponseTo3(Response response) {
        if (response == null) {
            return null;
        }
        return new Response.Builder().request(ToOkhttp3Converter.convertOkhttpRequestTo3(response.request())).protocol(ToOkhttp3Converter.convertOkhttpProtocolTo3(response.protocol())).code(response.code()).message(response.message()).handshake(ToOkhttp3Converter.convertOkhttpHandshakeTo3(response.handshake())).headers(ToOkhttp3Converter.convertOkhttpHeadersTo3(response.headers())).body(ToOkhttp3Converter.convertOkhttpResponseBodyTo3(response.body())).build();
    }

    public static okhttp3.Response convertOkhttpResponseTo3(Response response) {
        if (response == null) {
            return null;
        }
        okhttp3.Response okhttp3Response = ToOkhttp3Converter.convertBaseOkhttpResponseTo3(response);
        return okhttp3Response.newBuilder().cacheResponse(ToOkhttp3Converter.convertBaseOkhttpResponseTo3(response.cacheResponse())).networkResponse(ToOkhttp3Converter.convertBaseOkhttpResponseTo3(response.networkResponse())).build();
    }
}

