/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging;

import com.dkorobtsov.logging.converters.ToOkhttp3Converter;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.internal.http.HttpMethod;
import java.util.Arrays;
import java.util.Map;
import okhttp3.Request;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;

public class RequestDetails {
    private RequestDetails() {
    }

    public static class Builder {
        private int numberOfClientsInitialized = 0;
        private Request okhttpRequest;
        private HttpRequest apacheHttpRequest;

        public Builder from(Request okhttpRequest) {
            this.okhttpRequest = okhttpRequest;
            ++this.numberOfClientsInitialized;
            return this;
        }

        public Builder from(HttpRequest apacheHttpRequest) {
            this.apacheHttpRequest = apacheHttpRequest;
            ++this.numberOfClientsInitialized;
            return this;
        }

        public okhttp3.Request build() {
            if (this.numberOfClientsInitialized == 0 || this.numberOfClientsInitialized > 1) {
                throw new IllegalArgumentException("You can only initialize one client in the builder. No more then 1 'from' method per builder invocation allowed");
            }
            if (this.okhttpRequest != null) {
                return this.buildFromOkhttp();
            }
            return this.buildFromApacheHttpRequest();
        }

        private okhttp3.Request buildFromOkhttp() {
            Request.Builder builder = new Request.Builder();
            builder.url(this.okhttpRequest.url());
            Map headersMap = this.okhttpRequest.headers().toMultimap();
            headersMap.forEach((name, values) -> builder.addHeader(name, String.join((CharSequence)";", values)));
            if (HttpMethod.permitsRequestBody((String)this.okhttpRequest.method())) {
                builder.method(this.okhttpRequest.method(), ToOkhttp3Converter.convertOkhttpRequestBodyTo3(this.okhttpRequest));
            } else {
                builder.method(this.okhttpRequest.method(), null);
            }
            builder.tag(this.okhttpRequest.tag());
            builder.cacheControl(ToOkhttp3Converter.convertOkhttpCacheControlTo3(this.okhttpRequest.cacheControl()));
            return builder.build();
        }

        private okhttp3.Request buildFromApacheHttpRequest() {
            Request.Builder builder = new Request.Builder();
            builder.url(Builder.buildUrlFromApacheHttpRequest(this.apacheHttpRequest));
            Header[] headersMap = this.apacheHttpRequest.getAllHeaders();
            Arrays.stream(headersMap).forEach(header -> builder.addHeader(header.getName(), header.getValue()));
            String method = this.apacheHttpRequest.getRequestLine().getMethod();
            if (HttpMethod.permitsRequestBody((String)method)) {
                builder.method(method, ToOkhttp3Converter.convertApacheHttpRequestBodyTo3(this.apacheHttpRequest));
            } else {
                builder.method(method, null);
            }
            return builder.build();
        }

        private static String buildUrlFromApacheHttpRequest(HttpRequest request) {
            HttpHost target = ((HttpRequestWrapper)request).getTarget();
            String portString = target.getPort() == -1 ? "" : ":" + target.getPort();
            return String.format("%s://%s%s%s", target.getSchemeName(), target.getHostName(), portString, ((HttpRequestWrapper)request).getURI());
        }
    }
}

