/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging;

import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LogWriter;
import com.dkorobtsov.logging.ResponseDetails;
import com.dkorobtsov.logging.TextUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

class Printer {
    private static final int JSON_INDENT = 3;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String REGEX_LINE_SEPARATOR = "\r?\n";
    private static final String DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String[] OMITTED_RESPONSE = new String[]{"", "Omitted response body"};
    private static final String[] OMITTED_REQUEST = new String[]{"", "Omitted request body"};
    private static final String N = "\n";
    private static final String T = "\t";
    private static final String REQUEST_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String END_LINE = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String RESPONSE_UP_LINE = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BODY_TAG = "Body:";
    private static final String URL_TAG = "URL: ";
    private static final String METHOD_TAG = "Method: @";
    private static final String HEADERS_TAG = "Headers:";
    private static final String STATUS_CODE_TAG = "Status Code: ";
    private static final String RECEIVED_TAG = "Received in: ";
    private static final String CORNER_UP = "\u250c ";
    private static final String CORNER_BOTTOM = "\u2514 ";
    private static final String CENTER_LINE = "\u251c ";
    private static final String DEFAULT_LINE = "  ";

    private Printer() {
    }

    private static boolean isEmpty(String line) {
        return TextUtils.isEmpty(line) || N.equals(line) || T.equals(line) || TextUtils.isEmpty(line.trim());
    }

    static void printJsonRequest(LogWriter logWriter, Level level, int maxLineLength, Request request) {
        logWriter.log(REQUEST_UP_LINE);
        Printer.logLines(new String[]{URL_TAG + request.url()}, logWriter, maxLineLength, false);
        Printer.logLines(Printer.getRequest(request, level), logWriter, maxLineLength, true);
        String requestBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + Printer.bodyToString(request);
        if (level == Level.BASIC || level == Level.BODY) {
            Printer.logLines(requestBody.split(REGEX_LINE_SEPARATOR), logWriter, maxLineLength, true);
        }
        logWriter.log(END_LINE);
    }

    static void printJsonResponse(LogWriter logWriter, Level level, int maxLineLength, ResponseDetails responseDetails) {
        logWriter.log(RESPONSE_UP_LINE);
        Printer.logLines(new String[]{URL_TAG + responseDetails.url}, logWriter, maxLineLength, false);
        Printer.logLines(Printer.getResponse(level, responseDetails), logWriter, maxLineLength, true);
        String responseBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + Printer.formattedBody(responseDetails.originalBody);
        if (level == Level.BASIC || level == Level.BODY) {
            Printer.logLines(responseBody.split(REGEX_LINE_SEPARATOR), logWriter, maxLineLength, true);
        }
        logWriter.log(END_LINE);
    }

    static void printFileRequest(LogWriter logWriter, Level level, int maxLineLength, Request request) {
        logWriter.log(REQUEST_UP_LINE);
        Printer.logLines(new String[]{URL_TAG + request.url()}, logWriter, maxLineLength, false);
        Printer.logLines(Printer.getRequest(request, level), logWriter, maxLineLength, true);
        if (level == Level.BASIC || level == Level.BODY) {
            Printer.logLines(OMITTED_REQUEST, logWriter, maxLineLength, true);
        }
        logWriter.log(END_LINE);
    }

    static void printFileResponse(LogWriter logWriter, Level level, int maxLineLength, ResponseDetails responseDetails) {
        logWriter.log(RESPONSE_UP_LINE);
        Printer.logLines(new String[]{URL_TAG + responseDetails.url}, logWriter, maxLineLength, false);
        Printer.logLines(Printer.getResponse(level, responseDetails), logWriter, maxLineLength, true);
        if (level == Level.BASIC || level == Level.BODY) {
            Printer.logLines(OMITTED_RESPONSE, logWriter, maxLineLength, true);
        }
        logWriter.log(END_LINE);
    }

    private static String[] getRequest(Request request, Level level) {
        String header = request.headers().toString();
        boolean isLoggable = level == Level.HEADERS || level == Level.BASIC;
        String log = METHOD_TAG + request.method() + DOUBLE_SEPARATOR + Printer.printHeaderIfLoggable(header, isLoggable);
        return log.split(REGEX_LINE_SEPARATOR);
    }

    private static String[] getResponse(Level level, ResponseDetails responseDetails) {
        boolean isLoggable = level == Level.HEADERS || level == Level.BASIC;
        String segmentString = Printer.slashSegments(responseDetails.segmentList);
        String receivedTags = responseDetails.chainMs == 0L ? "" : " - Received in: " + responseDetails.chainMs + "ms";
        String log = (!TextUtils.isEmpty(segmentString) ? segmentString + " - " : "") + "is success : " + responseDetails.isSuccessful + receivedTags + DOUBLE_SEPARATOR + STATUS_CODE_TAG + responseDetails.code + " / " + responseDetails.message + DOUBLE_SEPARATOR + Printer.printHeaderIfLoggable(responseDetails.header, isLoggable);
        return log.split(REGEX_LINE_SEPARATOR);
    }

    private static String printHeaderIfLoggable(String header, boolean loggable) {
        return !Printer.isEmpty(header) && loggable ? HEADERS_TAG + LINE_SEPARATOR + Printer.dotHeaders(header) : "";
    }

    private static String slashSegments(List<String> segments) {
        StringBuilder segmentString = new StringBuilder();
        for (String segment : segments) {
            segmentString.append("/").append(segment);
        }
        return segmentString.toString();
    }

    private static String dotHeaders(String header) {
        String[] headers = header.split(REGEX_LINE_SEPARATOR);
        StringBuilder builder = new StringBuilder();
        String tag = "\u2500 ";
        if (headers.length > 1) {
            for (int i = 0; i < headers.length; ++i) {
                tag = i == 0 ? CORNER_UP : (i == headers.length - 1 ? CORNER_BOTTOM : CENTER_LINE);
                builder.append(tag).append(headers[i]).append(N);
            }
        } else {
            for (String item : headers) {
                builder.append(tag).append(item).append(N);
            }
        }
        return builder.toString();
    }

    private static void logLines(String[] lines, LogWriter logger, int maxLineLength, boolean withLineSize) {
        for (String line : lines) {
            if (line.isEmpty()) {
                logger.log(line);
                continue;
            }
            int lineLength = line.length();
            int maxLongSize = withLineSize ? maxLineLength : lineLength;
            for (int i = 0; i <= lineLength / maxLongSize; ++i) {
                int start = i * maxLongSize;
                int end = (i + 1) * maxLongSize;
                end = end > line.length() ? line.length() : end;
                logger.log(DEFAULT_LINE + line.substring(start, end));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String bodyToString(Request request) {
        Request copy = request.newBuilder().build();
        try (Buffer buffer = new Buffer();){
            if (copy.body() == null) {
                String string2 = "";
                return string2;
            }
            copy.body().writeTo((BufferedSink)buffer);
            String string = Printer.formattedBody(buffer.readUtf8());
            return string;
        }
        catch (IOException e) {
            return "{\"err\": \"" + e.getMessage() + "\"}";
        }
    }

    static String formattedBody(String msg) {
        String message;
        try {
            message = msg.trim().startsWith("{") ? Printer.formatAsJsonObject(msg) : (msg.trim().startsWith("[") ? Printer.formatAsJsonArray(msg) : (msg.trim().startsWith("<") ? Printer.formatAsXml(msg) : msg));
        }
        catch (JSONException e) {
            message = msg;
        }
        return message;
    }

    private static String formatAsJsonObject(String msg) {
        return new JSONObject(msg).toString(3);
    }

    private static String formatAsJsonArray(String msg) {
        return new JSONArray(msg).toString(3);
    }

    private static String formatAsXml(String msg) {
        try {
            InputSource src = new InputSource(new StringReader(msg));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            boolean keepDeclaration = msg.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            return msg;
        }
    }
}

