/*
 * Decompiled with CFR 0.152.
 */
package com.dkorobtsov.logging;

import com.dkorobtsov.logging.DefaultLogger;
import com.dkorobtsov.logging.Level;
import com.dkorobtsov.logging.LogFormatter;
import com.dkorobtsov.logging.LogWriter;
import com.dkorobtsov.logging.LoggerConfig;
import com.dkorobtsov.logging.interceptors.ApacheHttpRequestInterceptor;
import com.dkorobtsov.logging.interceptors.ApacheHttpResponseInterceptor;
import com.dkorobtsov.logging.interceptors.Okhttp3LoggingInterceptor;
import com.dkorobtsov.logging.interceptors.OkhttpLoggingInterceptor;
import java.util.concurrent.Executor;

public class LoggingInterceptor {
    private LoggingInterceptor() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isDebug = true;
        private int maxLineLength = 110;
        private Level level = Level.BASIC;
        private LogWriter logger;
        private LogFormatter formatter = LogFormatter.JUL_MESSAGE_ONLY;
        private Executor executor;

        public Builder logger(LogWriter logger) {
            this.logger = logger;
            return this;
        }

        LogWriter getLogger() {
            if (this.logger == null) {
                this.logger = new DefaultLogger(this.formatter);
            }
            return this.logger;
        }

        public Builder format(LogFormatter format) {
            this.formatter = format;
            return this;
        }

        LogFormatter getFormatter() {
            return this.formatter;
        }

        public Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        public boolean isDebug() {
            return this.isDebug;
        }

        public Builder level(Level level) {
            this.level = level;
            return this;
        }

        Level getLevel() {
            return this.level;
        }

        public Builder maxLineLength(int length) {
            if (length < 10 || length > 500) {
                throw new IllegalArgumentException("Invalid line length. Should be longer then 10 and shorter then 500.");
            }
            this.maxLineLength = length;
            return this;
        }

        int getMaxLineLength() {
            return this.maxLineLength;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        Executor getExecutor() {
            return this.executor;
        }

        public OkhttpLoggingInterceptor buildForOkhttp() {
            return new OkhttpLoggingInterceptor(this.loggerConfig());
        }

        public Okhttp3LoggingInterceptor buildForOkhttp3() {
            return new Okhttp3LoggingInterceptor(this.loggerConfig());
        }

        public ApacheHttpRequestInterceptor buildForApacheHttpClientRequest() {
            return new ApacheHttpRequestInterceptor(this.loggerConfig());
        }

        public ApacheHttpResponseInterceptor buildFordApacheHttpClientResponse() {
            return new ApacheHttpResponseInterceptor(this.loggerConfig());
        }

        private LoggerConfig loggerConfig() {
            return LoggerConfig.builder().executor(this.executor).formatter(this.formatter).logger(this.logger).loggable(this.isDebug).level(this.level).maxLineLength(this.maxLineLength).build();
        }
    }
}

