/*
 * Decompiled with CFR 0.152.
 */
package ru.dimorinny.floatingtextbutton;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import ru.dimorinny.floatingtextbutton.R;
import ru.dimorinny.floatingtextbutton.util.DimensionUtils;

public class FloatingTextButton
extends FrameLayout {
    private CardView container;
    private ImageView leftIconView;
    private ImageView rightIconView;
    private TextView titleView;
    private String title;
    private int titleColor;
    private Drawable leftIcon;
    private Drawable rightIcon;
    private int background;

    public FloatingTextButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateLayout(context);
        this.initAttributes(attrs);
        this.initView();
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        if (newTitle == null || newTitle.isEmpty()) {
            this.titleView.setVisibility(8);
        } else {
            this.titleView.setVisibility(0);
        }
        this.titleView.setText((CharSequence)newTitle);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitleColor(@ColorInt int color) {
        this.titleColor = color;
        this.titleView.setTextColor(color);
    }

    @ColorInt
    public int getTitleColor() {
        return this.titleColor;
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.background = color;
        this.container.setCardBackgroundColor(color);
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.background;
    }

    public void setLeftIconDrawable(Drawable drawable) {
        this.leftIcon = drawable;
        if (drawable != null) {
            this.leftIconView.setVisibility(0);
            this.leftIconView.setImageDrawable(drawable);
        } else {
            this.leftIconView.setVisibility(8);
        }
    }

    public void setRightIconDrawable(Drawable drawable) {
        this.rightIcon = drawable;
        if (drawable != null) {
            this.rightIconView.setVisibility(0);
            this.rightIconView.setImageDrawable(drawable);
        } else {
            this.rightIconView.setVisibility(8);
        }
    }

    public Drawable getLeftIconDrawable() {
        return this.leftIcon;
    }

    public Drawable getRightIconDrawable() {
        return this.rightIcon;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.container.setOnClickListener(listener);
    }

    public boolean hasOnClickListeners() {
        return this.container.hasOnClickListeners();
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.container.setOnLongClickListener(listener);
    }

    private void inflateLayout(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.widget_floating_text_button, (ViewGroup)this, true);
        this.container = (CardView)view.findViewById(R.id.layout_button_container);
        this.leftIconView = (ImageView)view.findViewById(R.id.layout_button_image_left);
        this.rightIconView = (ImageView)view.findViewById(R.id.layout_button_image_right);
        this.titleView = (TextView)view.findViewById(R.id.layout_button_text);
    }

    private void initAttributes(AttributeSet attrs) {
        TypedArray styleable2 = this.getContext().obtainStyledAttributes(attrs, R.styleable.FloatingTextButton, 0, 0);
        this.title = styleable2.getString(R.styleable.FloatingTextButton_floating_title);
        this.titleColor = styleable2.getColor(R.styleable.FloatingTextButton_floating_title_color, -16777216);
        this.leftIcon = styleable2.getDrawable(R.styleable.FloatingTextButton_floating_left_icon);
        this.rightIcon = styleable2.getDrawable(R.styleable.FloatingTextButton_floating_right_icon);
        this.background = styleable2.getColor(R.styleable.FloatingTextButton_floating_background_color, -1);
        styleable2.recycle();
    }

    private void initView() {
        this.setTitle(this.title);
        this.setTitleColor(this.titleColor);
        this.setLeftIconDrawable(this.leftIcon);
        this.setRightIconDrawable(this.rightIcon);
        this.setBackgroundColor(this.background);
        this.container.setContentPadding(this.getHorizontalPaddingValue(16), this.getVerticalPaddingValue(8), this.getHorizontalPaddingValue(16), this.getVerticalPaddingValue(8));
        this.initViewRadius();
    }

    private void initViewRadius() {
        this.container.post(new Runnable(){

            @Override
            public void run() {
                FloatingTextButton.this.container.setRadius((float)(FloatingTextButton.this.container.getHeight() / 2));
            }
        });
    }

    private int getVerticalPaddingValue(int dp) {
        if (Build.VERSION.SDK_INT < 21) {
            return DimensionUtils.dpToPx(this.getContext(), dp) / 4;
        }
        return DimensionUtils.dpToPx(this.getContext(), dp);
    }

    private int getHorizontalPaddingValue(int dp) {
        if (Build.VERSION.SDK_INT < 21) {
            return DimensionUtils.dpToPx(this.getContext(), dp) / 2;
        }
        return DimensionUtils.dpToPx(this.getContext(), dp);
    }
}

