/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.text;

import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.text.TokenType;
import be.quodlibet.boxable.text.WrappingFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public final class Tokenizer {
    private static final Token OPEN_TAG_I = new Token(TokenType.OPEN_TAG, "i");
    private static final Token OPEN_TAG_B = new Token(TokenType.OPEN_TAG, "b");
    private static final Token OPEN_TAG_OL = new Token(TokenType.OPEN_TAG, "ol");
    private static final Token OPEN_TAG_UL = new Token(TokenType.OPEN_TAG, "ul");
    private static final Token CLOSE_TAG_I = new Token(TokenType.CLOSE_TAG, "i");
    private static final Token CLOSE_TAG_B = new Token(TokenType.CLOSE_TAG, "b");
    private static final Token CLOSE_TAG_OL = new Token(TokenType.CLOSE_TAG, "ol");
    private static final Token CLOSE_TAG_UL = new Token(TokenType.CLOSE_TAG, "ul");
    private static final Token CLOSE_TAG_P = new Token(TokenType.CLOSE_TAG, "p");
    private static final Token CLOSE_TAG_LI = new Token(TokenType.CLOSE_TAG, "li");
    private static final Token POSSIBLE_WRAP_POINT = new Token(TokenType.POSSIBLE_WRAP_POINT, "");
    private static final Token WRAP_POINT_P = new Token(TokenType.WRAP_POINT, "p");
    private static final Token WRAP_POINT_LI = new Token(TokenType.WRAP_POINT, "li");
    private static final Token WRAP_POINT_BR = new Token(TokenType.WRAP_POINT, "br");

    private Tokenizer() {
    }

    private static boolean isWrapPointChar(char ch) {
        return ch == ' ' || ch == ',' || ch == '.' || ch == '-' || ch == '@' || ch == ':' || ch == ';' || ch == '\n' || ch == '\t' || ch == '\r' || ch == '\f' || ch == '\u000b';
    }

    private static Stack<Integer> findWrapPoints(String text) {
        Stack<Integer> result = new Stack<Integer>();
        result.push(text.length());
        for (int i = text.length() - 2; i >= 0; --i) {
            if (!Tokenizer.isWrapPointChar(text.charAt(i))) continue;
            result.push(i + 1);
        }
        return result;
    }

    private static Stack<Integer> findWrapPointsWithFunction(String text, WrappingFunction wrappingFunction) {
        String[] split = wrappingFunction.getLines(text);
        int textIndex = text.length();
        Stack<Integer> possibleWrapPoints = new Stack<Integer>();
        possibleWrapPoints.push(textIndex);
        for (int i = split.length - 1; i > 0; --i) {
            int splitLength = split[i].length();
            possibleWrapPoints.push(textIndex - splitLength);
            textIndex -= splitLength;
        }
        return possibleWrapPoints;
    }

    public static List<Token> tokenize(String text, WrappingFunction wrappingFunction) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (text != null) {
            Stack<Integer> possibleWrapPoints = wrappingFunction == null ? Tokenizer.findWrapPoints(text) : Tokenizer.findWrapPointsWithFunction(text, wrappingFunction);
            StringBuilder sb = new StringBuilder();
            Integer currentWrapPoint = possibleWrapPoints.pop();
            block3: for (int textIndex = 0; textIndex < text.length(); ++textIndex) {
                if (textIndex == currentWrapPoint) {
                    if (sb.length() > 0) {
                        tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                        sb.delete(0, sb.length());
                    }
                    tokens.add(POSSIBLE_WRAP_POINT);
                    currentWrapPoint = possibleWrapPoints.pop();
                }
                char c = text.charAt(textIndex);
                switch (c) {
                    case '<': {
                        boolean consumed = false;
                        if (textIndex < text.length() - 2) {
                            char lookahead4;
                            char lookahead3;
                            char lookahead1 = text.charAt(textIndex + 1);
                            char lookahead2 = text.charAt(textIndex + 2);
                            if ('i' == lookahead1 && '>' == lookahead2) {
                                if (sb.length() > 0) {
                                    tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(OPEN_TAG_I);
                                textIndex += 2;
                                consumed = true;
                            } else if ('b' == lookahead1 && '>' == lookahead2) {
                                if (sb.length() > 0) {
                                    tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(OPEN_TAG_B);
                                textIndex += 2;
                                consumed = true;
                            } else if ('b' == lookahead1 && 'r' == lookahead2) {
                                if (textIndex < text.length() - 3) {
                                    lookahead3 = text.charAt(textIndex + 3);
                                    if (lookahead3 == '>') {
                                        if (sb.length() > 0) {
                                            tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(WRAP_POINT_BR);
                                        textIndex += 3;
                                        consumed = true;
                                    } else if (textIndex < text.length() - 4) {
                                        lookahead4 = text.charAt(textIndex + 4);
                                        if (lookahead3 == '/' && lookahead4 == '>') {
                                            if (sb.length() > 0) {
                                                tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                                sb.delete(0, sb.length());
                                            }
                                            tokens.add(WRAP_POINT_BR);
                                            textIndex += 4;
                                            consumed = true;
                                        } else if (textIndex < text.length() - 5) {
                                            char lookahead5 = text.charAt(textIndex + 5);
                                            if (lookahead3 == ' ' && lookahead4 == '/' && lookahead5 == '>') {
                                                if (sb.length() > 0) {
                                                    tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                                    sb.delete(0, sb.length());
                                                }
                                                tokens.add(WRAP_POINT_BR);
                                                textIndex += 5;
                                                consumed = true;
                                            }
                                        }
                                    }
                                }
                            } else if ('p' == lookahead1 && '>' == lookahead2) {
                                if (sb.length() > 0) {
                                    tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                    sb.delete(0, sb.length());
                                }
                                tokens.add(WRAP_POINT_P);
                                textIndex += 2;
                                consumed = true;
                            } else if ('o' == lookahead1 && 'l' == lookahead2) {
                                if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                    if (sb.length() > 0) {
                                        tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(OPEN_TAG_OL);
                                    textIndex += 3;
                                    consumed = true;
                                }
                            } else if ('u' == lookahead1 && 'l' == lookahead2) {
                                if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                    if (sb.length() > 0) {
                                        tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(OPEN_TAG_UL);
                                    textIndex += 3;
                                    consumed = true;
                                }
                            } else if ('l' == lookahead1 && 'i' == lookahead2) {
                                if (textIndex < text.length() - 3 && (lookahead3 = text.charAt(textIndex + 3)) == '>') {
                                    if (sb.length() > 0) {
                                        tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                        sb.delete(0, sb.length());
                                    }
                                    tokens.add(WRAP_POINT_LI);
                                    textIndex += 3;
                                    consumed = true;
                                }
                            } else if ('/' == lookahead1) {
                                if (textIndex < text.length() - 3 && '>' == (lookahead3 = text.charAt(textIndex + 3))) {
                                    if ('i' == lookahead2) {
                                        if (sb.length() > 0) {
                                            tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(CLOSE_TAG_I);
                                        textIndex += 3;
                                        consumed = true;
                                    } else if ('b' == lookahead2) {
                                        if (sb.length() > 0) {
                                            tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(CLOSE_TAG_B);
                                        textIndex += 3;
                                        consumed = true;
                                    } else if ('p' == lookahead2) {
                                        if (sb.length() > 0) {
                                            tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(CLOSE_TAG_P);
                                        textIndex += 3;
                                        consumed = true;
                                    }
                                }
                                if (textIndex < text.length() - 4) {
                                    lookahead3 = text.charAt(textIndex + 3);
                                    lookahead4 = text.charAt(textIndex + 4);
                                    if ('l' == lookahead3) {
                                        if ('o' == lookahead2 && '>' == lookahead4) {
                                            if (sb.length() > 0) {
                                                tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                                sb.delete(0, sb.length());
                                            }
                                            tokens.add(CLOSE_TAG_OL);
                                            textIndex += 4;
                                            consumed = true;
                                        } else if ('u' == lookahead2 && '>' == lookahead4) {
                                            if (sb.length() > 0) {
                                                tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                                sb.delete(0, sb.length());
                                            }
                                            tokens.add(CLOSE_TAG_UL);
                                            textIndex += 4;
                                            consumed = true;
                                        }
                                    } else if ('l' == lookahead2 && 'i' == lookahead3 && '>' == lookahead4) {
                                        if (sb.length() > 0) {
                                            tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                                            sb.delete(0, sb.length());
                                        }
                                        tokens.add(CLOSE_TAG_LI);
                                        textIndex += 4;
                                        consumed = true;
                                    }
                                }
                            }
                        }
                        if (consumed) continue block3;
                        sb.append('<');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (sb.length() > 0) {
                tokens.add(Token.text(TokenType.TEXT, sb.toString()));
                sb.delete(0, sb.length());
            }
            tokens.add(POSSIBLE_WRAP_POINT);
            return tokens;
        }
        return Collections.emptyList();
    }
}

