/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.HTMLListNode;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.TextType;
import be.quodlibet.boxable.text.PipelineLayer;
import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.text.TokenType;
import be.quodlibet.boxable.text.Tokenizer;
import be.quodlibet.boxable.text.WrappingFunction;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class Paragraph {
    private float width = 500.0f;
    private String text;
    private float fontSize;
    private PDFont font = PDType1Font.HELVETICA;
    private PDFont fontBold = PDType1Font.HELVETICA_BOLD;
    private PDFont fontItalic = PDType1Font.HELVETICA_OBLIQUE;
    private PDFont fontBoldItalic = PDType1Font.HELVETICA_BOLD_OBLIQUE;
    private final WrappingFunction wrappingFunction;
    private HorizontalAlignment align;
    private TextType textType;
    private Color color;
    private float lineSpacing;
    private static final int DEFAULT_TAB = 4;
    private static final int DEFAULT_TAB_AND_BULLET = 6;
    private static final int BULLET_SPACE = 2;
    private boolean drawDebug;
    private final Map<Integer, Float> lineWidths = new HashMap<Integer, Float>();
    private Map<Integer, List<Token>> mapLineTokens = new LinkedHashMap<Integer, List<Token>>();
    private float maxLineWidth = -2.1474836E9f;
    private static final WrappingFunction DEFAULT_WRAP_FUNC = new WrappingFunction(){

        @Override
        public String[] getLines(String t) {
            return t.split("(?<=\\s|-|@|,|\\.|:|;)");
        }
    };

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align) {
        this(text, font, fontSize, width, align, null);
    }

    public Paragraph(String text, PDFont font, int fontSize, int width) {
        this(text, font, fontSize, width, HorizontalAlignment.LEFT, null);
    }

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align, WrappingFunction wrappingFunction) {
        this(text, font, fontSize, width, align, Color.BLACK, null, wrappingFunction);
    }

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align, Color color, TextType textType, WrappingFunction wrappingFunction) {
        this(text, font, fontSize, width, align, color, textType, wrappingFunction, 1.0f);
    }

    public Paragraph(String text, PDFont font, float fontSize, float width, HorizontalAlignment align, Color color, TextType textType, WrappingFunction wrappingFunction, float lineSpacing) {
        this.color = color;
        this.text = text;
        this.font = font;
        if (!FontUtils.getDefaultfonts().isEmpty()) {
            this.fontBold = FontUtils.getDefaultfonts().get("fontBold");
            this.fontBoldItalic = FontUtils.getDefaultfonts().get("fontBoldItalic");
            this.fontItalic = FontUtils.getDefaultfonts().get("fontItalic");
        }
        this.fontSize = fontSize;
        this.width = width;
        this.textType = textType;
        this.setAlign(align);
        this.wrappingFunction = wrappingFunction == null ? DEFAULT_WRAP_FUNC : wrappingFunction;
        this.lineSpacing = lineSpacing;
    }

    public List<String> getLines() {
        ArrayList<String> result = new ArrayList<String>();
        List<Token> tokens = Tokenizer.tokenize(this.text, this.wrappingFunction);
        int lineCounter = 0;
        boolean italic = false;
        boolean bold = false;
        boolean listElement = false;
        PDFont currentFont = this.font;
        int orderListElement = 1;
        int numberOfOrderedLists = 0;
        int listLevel = 0;
        Stack<HTMLListNode> stack = new Stack<HTMLListNode>();
        PipelineLayer textInLine = new PipelineLayer();
        PipelineLayer sinceLastWrapPoint = new PipelineLayer();
        block27: for (Token token : tokens) {
            switch (token.getType()) {
                case OPEN_TAG: {
                    if (this.isBold(token)) {
                        bold = true;
                        currentFont = this.getFont(bold, italic);
                    } else if (this.isItalic(token)) {
                        italic = true;
                        currentFont = this.getFont(bold, italic);
                    } else if (this.isList(token)) {
                        ++listLevel;
                        if (token.getData().equals("ol")) {
                            ++numberOfOrderedLists;
                            if (listLevel > 1) {
                                stack.add(new HTMLListNode(orderListElement - 1, stack.isEmpty() ? String.valueOf(orderListElement - 1) + "." : ((HTMLListNode)stack.peek()).getValue() + String.valueOf(orderListElement - 1) + "."));
                            }
                            orderListElement = 1;
                            textInLine.push(sinceLastWrapPoint);
                            if (textInLine.trimmedWidth() > 0.0f) {
                                result.add(textInLine.trimmedText());
                                this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                                this.mapLineTokens.put(lineCounter, textInLine.tokens());
                                this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                                textInLine.reset();
                                ++lineCounter;
                            }
                        } else if (token.getData().equals("ul")) {
                            textInLine.push(sinceLastWrapPoint);
                            if (textInLine.trimmedWidth() > 0.0f) {
                                result.add(textInLine.trimmedText());
                                this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                                this.mapLineTokens.put(lineCounter, textInLine.tokens());
                                this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                                textInLine.reset();
                                ++lineCounter;
                            }
                        }
                    }
                    sinceLastWrapPoint.push(token);
                    break;
                }
                case CLOSE_TAG: {
                    String tabBullet;
                    String orderingNumber;
                    if (this.isBold(token)) {
                        bold = false;
                        currentFont = this.getFont(bold, italic);
                        sinceLastWrapPoint.push(token);
                    } else if (this.isItalic(token)) {
                        italic = false;
                        currentFont = this.getFont(bold, italic);
                        sinceLastWrapPoint.push(token);
                    } else if (this.isList(token)) {
                        --listLevel;
                        if (token.getData().equals("ol") && --numberOfOrderedLists > 0) {
                            orderListElement = ((HTMLListNode)stack.peek()).getOrderingNumber() + 1;
                            stack.pop();
                        }
                        if (listLevel == 0) {
                            result.add(" ");
                            this.lineWidths.put(lineCounter, Float.valueOf(0.0f));
                            this.mapLineTokens.put(lineCounter, new ArrayList());
                            ++lineCounter;
                        }
                    } else if (this.isListElement(token)) {
                        if (textInLine.width() + sinceLastWrapPoint.trimmedWidth() > this.width) {
                            result.add(textInLine.trimmedText());
                            this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                            this.mapLineTokens.put(lineCounter, textInLine.tokens());
                            this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                            textInLine.reset();
                            ++lineCounter;
                            if (numberOfOrderedLists > 0) {
                                orderingNumber = stack.isEmpty() ? String.valueOf(orderListElement) + "." : ((HTMLListNode)stack.pop()).getValue() + ".";
                                stack.add(new HTMLListNode(orderListElement, orderingNumber));
                                String tab = String.valueOf(Paragraph.indentLevel(4));
                                String orderingNumberAndTab = orderingNumber + tab;
                                try {
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(orderingNumberAndTab) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                ++orderListElement;
                            } else {
                                try {
                                    tabBullet = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(6) : Paragraph.indentLevel(4);
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tabBullet) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            textInLine.push(sinceLastWrapPoint);
                        }
                        textInLine.push(sinceLastWrapPoint);
                        result.add(textInLine.trimmedText());
                        this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                        this.mapLineTokens.put(lineCounter, textInLine.tokens());
                        this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                        textInLine.reset();
                        ++lineCounter;
                        listElement = false;
                    }
                    if (!this.isParagraph(token)) break;
                    if (textInLine.width() + sinceLastWrapPoint.trimmedWidth() > this.width) {
                        result.add(textInLine.trimmedText());
                        this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                        this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                        this.mapLineTokens.put(lineCounter, textInLine.tokens());
                        ++lineCounter;
                        textInLine.reset();
                    }
                    textInLine.push(sinceLastWrapPoint);
                    result.add(textInLine.trimmedText());
                    this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                    this.mapLineTokens.put(lineCounter, textInLine.tokens());
                    this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                    textInLine.reset();
                    result.add(" ");
                    this.lineWidths.put(++lineCounter, Float.valueOf(0.0f));
                    this.mapLineTokens.put(lineCounter, new ArrayList());
                    ++lineCounter;
                    break;
                }
                case POSSIBLE_WRAP_POINT: {
                    String tab;
                    String tabBullet;
                    if (textInLine.width() + sinceLastWrapPoint.trimmedWidth() > this.width) {
                        if (!textInLine.isEmpty()) {
                            result.add(textInLine.trimmedText());
                            this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                            this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                            this.mapLineTokens.put(lineCounter, textInLine.tokens());
                            ++lineCounter;
                            textInLine.reset();
                        }
                        if (listElement) {
                            if (numberOfOrderedLists > 0) {
                                tab = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(4) : Paragraph.indentLevel(4);
                                String orderingNumber = stack.isEmpty() ? String.valueOf(orderListElement) + "." : ((HTMLListNode)stack.peek()).getValue() + "." + String.valueOf(orderListElement - 1) + ".";
                                try {
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tab + orderingNumber) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    tabBullet = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(6) : Paragraph.indentLevel(4);
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tabBullet) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        textInLine.push(sinceLastWrapPoint);
                        break;
                    }
                    textInLine.push(sinceLastWrapPoint);
                    break;
                }
                case WRAP_POINT: {
                    String tab;
                    String tabBullet;
                    String orderingNumber;
                    if (textInLine.width() + sinceLastWrapPoint.trimmedWidth() > this.width) {
                        result.add(textInLine.trimmedText());
                        this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                        this.mapLineTokens.put(lineCounter, textInLine.tokens());
                        this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                        textInLine.reset();
                        ++lineCounter;
                        if (listElement) {
                            if (!this.getAlign().equals((Object)HorizontalAlignment.LEFT)) {
                                listLevel = 0;
                            }
                            if (numberOfOrderedLists > 0) {
                                orderingNumber = stack.isEmpty() ? String.valueOf("1") + "." : ((HTMLListNode)stack.pop()).getValue() + ". ";
                                String tab2 = String.valueOf(Paragraph.indentLevel(4));
                                String orderingNumberAndTab = orderingNumber + tab2;
                                try {
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(orderingNumberAndTab) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    tabBullet = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(6) : Paragraph.indentLevel(4);
                                    textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tabBullet) / 1000.0f * this.getFontSize())));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        textInLine.push(sinceLastWrapPoint);
                    }
                    if (this.isParagraph(token)) {
                        if (!(textInLine.trimmedWidth() > 0.0f)) break;
                        result.add(" ");
                        this.lineWidths.put(lineCounter, Float.valueOf(0.0f));
                        this.mapLineTokens.put(lineCounter, new ArrayList());
                        ++lineCounter;
                        break;
                    }
                    if (this.isListElement(token)) {
                        listElement = true;
                        try {
                            tab = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(4) : Paragraph.indentLevel(4);
                            textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tab) / 1000.0f * this.getFontSize())));
                            if (numberOfOrderedLists > 0) {
                                String orderingNumber2 = listLevel > 1 ? ((HTMLListNode)stack.peek()).getValue() + String.valueOf(orderListElement) + ". " : String.valueOf(orderListElement) + ". ";
                                textInLine.push(currentFont, this.fontSize, new Token(TokenType.ORDERING, orderingNumber2));
                                ++orderListElement;
                                break;
                            }
                            textInLine.push(currentFont, this.fontSize, new Token(TokenType.BULLET, " "));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    textInLine.push(sinceLastWrapPoint);
                    result.add(textInLine.trimmedText());
                    this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                    this.mapLineTokens.put(lineCounter, textInLine.tokens());
                    this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                    textInLine.reset();
                    ++lineCounter;
                    if (listLevel <= 0) break;
                    try {
                        if (numberOfOrderedLists > 0) {
                            tab = this.getAlign().equals((Object)HorizontalAlignment.LEFT) ? Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) : Paragraph.indentLevel(4);
                            String orderingNumber3 = listLevel > 1 ? ((HTMLListNode)stack.peek()).getValue() + String.valueOf(orderListElement) + ". " : String.valueOf(orderListElement) + ". ";
                            String tabAndOrderingNumber = tab + orderingNumber3;
                            textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tabAndOrderingNumber) / 1000.0f * this.getFontSize())));
                            ++orderListElement;
                            break;
                        }
                        if (!this.getAlign().equals((Object)HorizontalAlignment.LEFT)) continue block27;
                        tab = Paragraph.indentLevel(4 * Math.max(listLevel - 1, 0)) + Paragraph.indentLevel(4) + Paragraph.indentLevel(2);
                        textInLine.push(currentFont, this.fontSize, new Token(TokenType.PADDING, String.valueOf(this.font.getStringWidth(tab) / 1000.0f * this.getFontSize())));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case TEXT: {
                    try {
                        String word = token.getData();
                        if (this.font.getStringWidth(word) / 1000.0f * this.fontSize > this.width && this.width > this.font.getAverageFontWidth() / 1000.0f * this.fontSize) {
                            boolean alreadyTextInLine = false;
                            if (textInLine.trimmedWidth() > 0.0f) {
                                alreadyTextInLine = true;
                            }
                            while (this.font.getStringWidth(word) / 1000.0f * this.fontSize > this.width) {
                                float width = 0.0f;
                                float firstPartWordWidth = 0.0f;
                                float restOfTheWordWidth = 0.0f;
                                String lastTextToken = word;
                                StringBuilder firstPartOfWord = new StringBuilder();
                                StringBuilder restOfTheWord = new StringBuilder();
                                for (int i = 0; i < lastTextToken.length(); ++i) {
                                    char c = lastTextToken.charAt(i);
                                    try {
                                        width += this.font.getStringWidth("" + c) / 1000.0f * this.fontSize;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    if (alreadyTextInLine) {
                                        if (width < this.width - textInLine.trimmedWidth()) {
                                            firstPartOfWord.append("" + c);
                                            firstPartWordWidth = Math.max(width, firstPartWordWidth);
                                            continue;
                                        }
                                        restOfTheWord.append("" + c);
                                        restOfTheWordWidth = Math.max(width, restOfTheWordWidth);
                                        continue;
                                    }
                                    if (width < this.width) {
                                        firstPartOfWord.append("" + c);
                                        firstPartWordWidth = Math.max(width, firstPartWordWidth);
                                        continue;
                                    }
                                    if (i == 0) {
                                        firstPartOfWord.append("" + c);
                                        for (int j = 1; j < lastTextToken.length(); ++j) {
                                            restOfTheWord.append("" + lastTextToken.charAt(j));
                                        }
                                        break;
                                    }
                                    restOfTheWord.append("" + c);
                                    restOfTheWordWidth = Math.max(width, restOfTheWordWidth);
                                }
                                alreadyTextInLine = false;
                                sinceLastWrapPoint.push(currentFont, this.fontSize, new Token(TokenType.TEXT, firstPartOfWord.toString()));
                                textInLine.push(sinceLastWrapPoint);
                                result.add(textInLine.trimmedText());
                                this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
                                this.mapLineTokens.put(lineCounter, textInLine.tokens());
                                this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
                                textInLine.reset();
                                ++lineCounter;
                                word = restOfTheWord.toString();
                            }
                            sinceLastWrapPoint.push(currentFont, this.fontSize, new Token(TokenType.TEXT, word));
                            break;
                        }
                        sinceLastWrapPoint.push(currentFont, this.fontSize, token);
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (sinceLastWrapPoint.trimmedWidth() + textInLine.trimmedWidth() > 0.0f) {
            textInLine.push(sinceLastWrapPoint);
            result.add(textInLine.trimmedText());
            this.lineWidths.put(lineCounter, Float.valueOf(textInLine.trimmedWidth()));
            this.mapLineTokens.put(lineCounter, textInLine.tokens());
            this.maxLineWidth = Math.max(this.maxLineWidth, textInLine.trimmedWidth());
        }
        return result;
    }

    private boolean isItalic(Token token) {
        return "i".equals(token.getData());
    }

    private boolean isBold(Token token) {
        return "b".equals(token.getData());
    }

    private boolean isParagraph(Token token) {
        return "p".equals(token.getData());
    }

    private boolean isListElement(Token token) {
        return "li".equals(token.getData());
    }

    private boolean isList(Token token) {
        return "ul".equals(token.getData()) || "ol".equals(token.getData());
    }

    private static String indentLevel(int numberOfSpaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfSpaces; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public PDFont getFont(boolean isBold, boolean isItalic) {
        if (isBold) {
            if (isItalic) {
                return this.fontBoldItalic;
            }
            return this.fontBold;
        }
        if (isItalic) {
            return this.fontItalic;
        }
        return this.font;
    }

    public float write(PDPageContentStream stream, float cursorX, float cursorY) {
        if (this.drawDebug) {
            PDStreamUtils.rectFontMetrics(stream, cursorX, cursorY, this.font, this.fontSize);
            PDStreamUtils.rect(stream, cursorX, cursorY, this.width, 1.0f, Color.RED);
        }
        for (String line : this.getLines()) {
            line = line.trim();
            float textX = cursorX;
            switch (this.align) {
                case CENTER: {
                    textX += this.getHorizontalFreeSpace(line) / 2.0f;
                    break;
                }
                case LEFT: {
                    break;
                }
                case RIGHT: {
                    textX += this.getHorizontalFreeSpace(line);
                }
            }
            PDStreamUtils.write(stream, line, this.font, this.fontSize, textX, cursorY, this.color);
            if (this.textType != null) {
                switch (this.textType) {
                    case HIGHLIGHT: 
                    case SQUIGGLY: 
                    case STRIKEOUT: {
                        throw new UnsupportedOperationException("Not implemented.");
                    }
                    case UNDERLINE: {
                        float y = (float)((double)(cursorY - FontUtils.getHeight(this.font, this.fontSize) - FontUtils.getDescent(this.font, this.fontSize)) - 1.5);
                        try {
                            float titleWidth = this.font.getStringWidth(line) / 1000.0f * this.fontSize;
                            stream.moveTo(textX, y);
                            stream.lineTo(textX + titleWidth, y);
                            stream.stroke();
                            break;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Unable to underline text", e);
                        }
                    }
                }
            }
            cursorY -= this.getFontHeight();
        }
        return cursorY;
    }

    public float getHeight() {
        if (this.getLines().size() == 0) {
            return 0.0f;
        }
        return (float)(this.getLines().size() - 1) * this.getLineSpacing() * this.getFontHeight() + this.getFontHeight();
    }

    public float getFontHeight() {
        return FontUtils.getHeight(this.font, this.fontSize);
    }

    @Deprecated
    public float getFontWidth() {
        return this.font.getFontDescriptor().getFontBoundingBox().getWidth() / 1000.0f * this.fontSize;
    }

    @Deprecated
    public Paragraph withWidth(int width) {
        this.width = width;
        return this;
    }

    @Deprecated
    public Paragraph withFont(PDFont font, int fontSize) {
        this.font = font;
        this.fontSize = fontSize;
        return this;
    }

    @Deprecated
    public Paragraph withColor(int color) {
        this.color = new Color(color);
        return this;
    }

    @Deprecated
    public int getColor() {
        return this.color.getRGB();
    }

    private float getHorizontalFreeSpace(String text) {
        try {
            float tw = this.font.getStringWidth(text.trim()) / 1000.0f * this.fontSize;
            return this.width - tw;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to calculate text width", e);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public String getText() {
        return this.text;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PDFont getFont() {
        return this.font;
    }

    public HorizontalAlignment getAlign() {
        return this.align;
    }

    public void setAlign(HorizontalAlignment align) {
        this.align = align;
    }

    public boolean isDrawDebug() {
        return this.drawDebug;
    }

    public void setDrawDebug(boolean drawDebug) {
        this.drawDebug = drawDebug;
    }

    public WrappingFunction getWrappingFunction() {
        return this.wrappingFunction;
    }

    public float getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public float getLineWidth(int key) {
        return this.lineWidths.get(key).floatValue();
    }

    public Map<Integer, List<Token>> getMapLineTokens() {
        return this.mapLineTokens;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }
}

