/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.text;

import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.text.TokenType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PipelineLayer {
    private final Pattern whitespace = Pattern.compile("(?:\r\n|\n\r|[ \t\n\r\\f])+\\z");
    private final StringBuilder text = new StringBuilder();
    private String lastTextToken = "";
    private List<Token> tokens = new ArrayList<Token>();
    private String trimmedLastTextToken = "";
    private float width;
    private float widthLastToken;
    private float widthTrimmedLastToken;
    private float widthCurrentText;

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public void push(Token token) {
        this.tokens.add(token);
    }

    public void push(PDFont font, float fontSize, Token token) throws IOException {
        if (token.getType().equals((Object)TokenType.PADDING)) {
            this.width += Float.parseFloat(token.getData());
        }
        if (token.getType().equals((Object)TokenType.BULLET)) {
            this.text.append(token.getData());
            this.width += font.getStringWidth(token.getData()) / 1000.0f * fontSize;
        }
        if (token.getType().equals((Object)TokenType.ORDERING)) {
            this.text.append(token.getData());
            this.width += font.getStringWidth(token.getData()) / 1000.0f * fontSize;
        }
        if (token.getType().equals((Object)TokenType.TEXT)) {
            this.text.append(this.lastTextToken);
            this.width += this.widthLastToken;
            this.lastTextToken = token.getData();
            this.trimmedLastTextToken = this.whitespace.matcher(this.lastTextToken).replaceAll("");
            this.widthLastToken = font.getStringWidth(this.lastTextToken) / 1000.0f * fontSize;
            this.widthTrimmedLastToken = font.getStringWidth(this.trimmedLastTextToken) / 1000.0f * fontSize;
            this.widthCurrentText = font.getStringWidth(this.text.toString()) / 1000.0f * fontSize;
        }
        this.push(token);
    }

    public void push(PipelineLayer pipeline) {
        this.text.append(this.lastTextToken);
        this.width += this.widthLastToken;
        this.text.append((CharSequence)pipeline.text);
        if (pipeline.text.length() > 0) {
            this.width += pipeline.widthCurrentText;
        }
        this.lastTextToken = pipeline.lastTextToken;
        this.trimmedLastTextToken = pipeline.trimmedLastTextToken;
        this.widthLastToken = pipeline.widthLastToken;
        this.widthTrimmedLastToken = pipeline.widthTrimmedLastToken;
        this.tokens.addAll(pipeline.tokens);
        pipeline.reset();
    }

    public void reset() {
        this.text.delete(0, this.text.length());
        this.width = 0.0f;
        this.lastTextToken = "";
        this.trimmedLastTextToken = "";
        this.widthLastToken = 0.0f;
        this.widthTrimmedLastToken = 0.0f;
        this.tokens.clear();
    }

    public String trimmedText() {
        return this.text.toString() + this.trimmedLastTextToken;
    }

    public float width() {
        return this.width + this.widthLastToken;
    }

    public float trimmedWidth() {
        return this.width + this.widthTrimmedLastToken;
    }

    public List<Token> tokens() {
        return new ArrayList<Token>(this.tokens);
    }

    public String toString() {
        return this.text.toString() + "(" + this.lastTextToken + ") [width: " + this.width() + ", trimmed: " + this.trimmedWidth() + "]";
    }
}

