/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.page.PageProvider;
import be.quodlibet.boxable.text.WrappingFunction;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Table<T extends PDPage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Table.class);
    public final PDDocument document;
    private float margin;
    private T currentPage;
    private PDPageContentStream tableContentStream;
    private List<PDOutlineItem> bookmarks;
    private Row<T> header;
    private List<Row<T>> rows = new ArrayList<Row<T>>();
    private final float yStartNewPage;
    private float yStart;
    private final float width;
    private final boolean drawLines;
    private final boolean drawContent;
    private float headerBottomMargin = 4.0f;
    private boolean tableIsBroken = false;
    private PageProvider<T> pageProvider;
    private final float pageTopMargin;
    private final float pageBottomMargin;
    private boolean drawDebug;

    @Deprecated
    public Table(float yStart, float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent) throws IOException {
        this(yStart, yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, currentPage, drawLines, drawContent, null);
    }

    @Deprecated
    public Table(float yStartNewPage, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent) throws IOException {
        this(yStartNewPage, 0.0f, pageBottomMargin, width, margin, document, drawLines, drawContent, null);
    }

    public Table(float yStart, float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, T currentPage, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.yStart = yStart;
        this.pageBottomMargin = pageBottomMargin;
        this.currentPage = currentPage;
        this.pageProvider = pageProvider;
        this.loadFonts();
    }

    public Table(float yStartNewPage, float pageTopMargin, float pageBottomMargin, float width, float margin, PDDocument document, boolean drawLines, boolean drawContent, PageProvider<T> pageProvider) throws IOException {
        this.pageTopMargin = pageTopMargin;
        this.document = document;
        this.drawLines = drawLines;
        this.drawContent = drawContent;
        this.yStartNewPage = yStartNewPage;
        this.margin = margin;
        this.width = width;
        this.pageProvider = pageProvider;
        this.pageBottomMargin = pageBottomMargin;
        this.loadFonts();
        this.currentPage = pageProvider.createPage();
    }

    protected abstract void loadFonts() throws IOException;

    protected PDType0Font loadFont(String fontPath) throws IOException {
        return FontUtils.loadFont(this.getDocument(), fontPath);
    }

    protected PDDocument getDocument() {
        return this.document;
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, boolean drawHeaderMargin) throws IOException {
        this.drawTitle(title, font, fontSize, tableWidth, height, alignment, freeSpaceForPageBreak, null, drawHeaderMargin);
    }

    public void drawTitle(String title, PDFont font, int fontSize, float tableWidth, float height, String alignment, float freeSpaceForPageBreak, WrappingFunction wrappingFunction, boolean drawHeaderMargin) throws IOException {
        this.ensureStreamIsOpen();
        if (this.isEndOfPage(freeSpaceForPageBreak)) {
            this.tableContentStream.close();
            this.pageBreak();
        }
        if (title == null) {
            this.yStart -= height;
        } else {
            PDPageContentStream articleTitle = this.createPdPageContentStream();
            Paragraph paragraph = new Paragraph(title, font, fontSize, tableWidth, HorizontalAlignment.get(alignment), wrappingFunction);
            paragraph.setDrawDebug(this.drawDebug);
            this.yStart = paragraph.write(articleTitle, this.margin, this.yStart);
            if (paragraph.getHeight() < height) {
                this.yStart -= height - paragraph.getHeight();
            }
            articleTitle.close();
            if (this.drawDebug) {
                PDStreamUtils.rect(this.tableContentStream, this.margin, this.yStart, this.width, this.headerBottomMargin, Color.CYAN);
            }
        }
        if (drawHeaderMargin) {
            this.yStart -= this.headerBottomMargin;
        }
    }

    public float getWidth() {
        return this.width;
    }

    public Row<T> createRow(float height) {
        Row row = new Row(this, height);
        this.rows.add(row);
        return row;
    }

    public Row<T> createRow(List<Cell<T>> cells, float height) {
        Row<T> row = new Row<T>(this, cells, height);
        this.rows.add(row);
        return row;
    }

    public float draw() throws IOException {
        this.ensureStreamIsOpen();
        for (Row<T> row : this.rows) {
            float headerHeightIncludingFirstDataRow;
            if (row == this.header && this.isEndOfPage(headerHeightIncludingFirstDataRow = this.header.getHeight() + this.rows.get(1).getHeight())) {
                this.pageBreak();
            }
            this.drawRow(row);
        }
        this.endTable();
        return this.yStart;
    }

    private void drawRow(Row<T> row) throws IOException {
        if (row.getBookmark() != null) {
            PDPageXYZDestination bookmarkDestination = new PDPageXYZDestination();
            bookmarkDestination.setPage(this.currentPage);
            bookmarkDestination.setTop((int)this.yStart);
            row.getBookmark().setDestination((PDDestination)bookmarkDestination);
            this.addBookmark(row.getBookmark());
        }
        if (this.isEndOfPage(row)) {
            this.endTable();
            this.pageBreak();
            if (this.header != null) {
                this.drawRow(this.header);
            } else {
                LOGGER.warn("No Header Row Defined.");
            }
        }
        if (this.drawLines) {
            this.drawVerticalLines(row);
        }
        if (this.drawContent) {
            this.drawCellContent(row);
        }
    }

    private T createNewPage() {
        if (this.pageProvider != null) {
            return this.pageProvider.createPage();
        }
        return this.createPage();
    }

    @Deprecated
    protected T createPage() {
        throw new IllegalStateException("You either have to provide a " + PageProvider.class.getCanonicalName() + " or override this method");
    }

    private PDPageContentStream createPdPageContentStream() throws IOException {
        return new PDPageContentStream(this.getDocument(), this.getCurrentPage(), true, true);
    }

    private void drawCellContent(Row<T> row) throws IOException {
        float cursorX = this.margin;
        for (Cell<T> cell : row.getCells()) {
            if (cell.getFont() == null) {
                throw new IllegalArgumentException("Font is null on Cell=" + cell.getText());
            }
            float cursorY = this.yStart - cell.getTopPadding() - FontUtils.getHeight(cell.getFont(), cell.getFontSize()) - FontUtils.getDescent(cell.getFont(), cell.getFontSize());
            switch (cell.getValign()) {
                case TOP: {
                    break;
                }
                case MIDDLE: {
                    cursorY -= cell.getVerticalFreeSpace() / 2.0f;
                    break;
                }
                case BOTTOM: {
                    cursorY -= cell.getVerticalFreeSpace();
                }
            }
            float cellStartX = cursorX;
            float lineStartX = cursorX += cell.getLeftPadding();
            this.tableContentStream.setFont(cell.getFont(), cell.getFontSize());
            if (row.equals(this.header) || cell.isHeaderCell()) {
                this.tableContentStream.setFont(cell.getFontBold(), cell.getFontSize());
            }
            this.tableContentStream.setNonStrokingColor(cell.getTextColor());
            float tw = 0.0f;
            for (String line : cell.getParagraph().getLines()) {
                line = line.trim();
                cursorX = lineStartX;
                switch (cell.getAlign()) {
                    case CENTER: {
                        cursorX += cell.getHorizontalFreeSpace() / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorX += cell.getHorizontalFreeSpace();
                    }
                }
                tw = Math.max(tw, cell.getFont().getStringWidth(line));
                tw = tw / 1000.0f * cell.getFontSize();
                float freeSpaceWithinLine = cell.getInnerWidth() - cell.getHorizontalFreeSpace() - tw;
                switch (cell.getAlign()) {
                    case CENTER: {
                        cursorX += freeSpaceWithinLine / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorX += freeSpaceWithinLine;
                    }
                }
                this.tableContentStream.beginText();
                this.tableContentStream.newLineAtOffset(cursorX, cursorY);
                this.tableContentStream.showText(line);
                this.tableContentStream.endText();
                this.tableContentStream.closePath();
                cursorY -= cell.getParagraph().getFontHeight();
            }
            cursorX = cellStartX + cell.getWidth();
        }
        this.yStart -= row.getHeight();
    }

    private void drawVerticalLines(Row<T> row) throws IOException {
        float xStart = this.margin;
        float xEnd = row.xEnd();
        this.drawLine("Row Upper Border ", xStart, this.yStart, xEnd, this.yStart);
        Iterator<Cell<T>> cellIterator = row.getCells().iterator();
        while (cellIterator.hasNext()) {
            Cell<T> cell = cellIterator.next();
            this.fillCellColor(cell, this.yStart, xStart, cellIterator);
            float yEnd = this.yStart - row.getHeight();
            this.drawLine("Cell Separator ", xStart, this.yStart, xStart, yEnd);
            xStart += this.getWidth(cell, cellIterator);
        }
        float yEnd = this.yStart - row.getHeight();
        this.drawLine("Last Cell ", xEnd, this.yStart, xEnd, yEnd);
    }

    private void drawLine(String type, float xStart, float yStart, float xEnd, float yEnd) throws IOException {
        this.tableContentStream.setNonStrokingColor(Color.BLACK);
        this.tableContentStream.setStrokingColor(Color.BLACK);
        this.tableContentStream.moveTo(xStart, yStart);
        this.tableContentStream.lineTo(xEnd, yEnd);
        this.tableContentStream.stroke();
        this.tableContentStream.closePath();
    }

    private void fillCellColor(Cell<T> cell, float yStart, float xStart, Iterator<Cell<T>> cellIterator) throws IOException {
        if (cell.getFillColor() != null) {
            this.tableContentStream.setNonStrokingColor(cell.getFillColor());
            float height = cell.getHeight() - 1.0f;
            float cellWidth = this.getWidth(cell, cellIterator);
            this.tableContentStream.addRect(xStart, yStart -= cell.getHeight(), cellWidth, height);
            this.tableContentStream.fill();
            this.tableContentStream.closePath();
            this.tableContentStream.setNonStrokingColor(Color.BLACK);
        }
    }

    private float getWidth(Cell<T> cell, Iterator<Cell<T>> cellIterator) {
        float width = cellIterator.hasNext() ? cell.getWidth() : cell.getExtraWidth();
        return width;
    }

    private void ensureStreamIsOpen() throws IOException {
        if (this.tableContentStream == null) {
            this.tableContentStream = this.createPdPageContentStream();
        }
    }

    private void endTable() throws IOException {
        if (this.drawLines) {
            this.drawLine("Row Bottom Border ", this.margin, this.yStart, this.margin + this.width, this.yStart);
        }
        this.tableContentStream.close();
    }

    public T getCurrentPage() {
        Preconditions.checkNotNull(this.currentPage, (Object)"No current page defined.");
        return this.currentPage;
    }

    private boolean isEndOfPage(Row<T> row) {
        boolean isEndOfPage;
        float currentY = this.yStart - row.getHeight();
        boolean bl = isEndOfPage = currentY <= this.pageBottomMargin;
        if (isEndOfPage) {
            this.setTableIsBroken(true);
            System.out.println("Its end of page. Table row height caused the problem.");
        }
        return isEndOfPage;
    }

    private boolean isEndOfPage(float freeSpaceForPageBreak) {
        boolean isEndOfPage;
        float currentY = this.yStart - freeSpaceForPageBreak;
        boolean bl = isEndOfPage = currentY <= this.pageBottomMargin;
        if (isEndOfPage) {
            this.setTableIsBroken(true);
            System.out.println("Its end of the page. Table title caused this problem.");
        }
        return isEndOfPage;
    }

    private void pageBreak() throws IOException {
        this.tableContentStream.close();
        this.yStart = this.yStartNewPage - this.pageTopMargin;
        this.currentPage = this.createNewPage();
        this.tableContentStream = this.createPdPageContentStream();
    }

    private void addBookmark(PDOutlineItem bookmark) {
        if (this.bookmarks == null) {
            this.bookmarks = new ArrayList<PDOutlineItem>();
        }
        this.bookmarks.add(bookmark);
    }

    public List<PDOutlineItem> getBookmarks() {
        return this.bookmarks;
    }

    public void setHeader(Row<T> header) {
        this.header = header;
    }

    public Row<T> getHeader() {
        if (this.header == null) {
            throw new IllegalArgumentException("Header Row not set on table");
        }
        return this.header;
    }

    public float getMargin() {
        return this.margin;
    }

    protected void setYStart(float yStart) {
        this.yStart = yStart;
    }

    public boolean isDrawDebug() {
        return this.drawDebug;
    }

    public void setDrawDebug(boolean drawDebug) {
        this.drawDebug = drawDebug;
    }

    public boolean tableIsBroken() {
        return this.tableIsBroken;
    }

    public float getHeaderAndDataHeight() {
        return this.header == null ? 0.0f : this.header.getHeight() + this.rows.get(this.header == null ? 0 : 1).getHeight();
    }

    public void setTableIsBroken(boolean tableIsBroken) {
        this.tableIsBroken = tableIsBroken;
    }
}

