/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0011J\u0012\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0002J\u0006\u0010\u0017\u001a\u00020\u0006J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\b\u0010\u001d\u001a\u00020\u0011H\u0014J\u0012\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020 H\u0016J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CropProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mCrop", "", "mCropAspectX", "", "mCropAspectY", "mCropImageFile", "Ljava/io/File;", "mFileDir", "mMaxHeight", "", "mMaxWidth", "cropImage", "", "uri", "Landroid/net/Uri;", "delete", "handleResult", "file", "isCropEnabled", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onFailure", "onRestoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "outState", "startIntent", "Companion", "imagepicker_release"})
public final class CropProvider
extends BaseProvider {
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final boolean mCrop;
    private final float mCropAspectX;
    private final float mCropAspectY;
    private File mCropImageFile;
    private final File mFileDir;
    private static final String TAG;
    private static final String STATE_CROP_FILE = "state.crop_file";
    public static final Companion Companion;

    @Override
    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putSerializable(STATE_CROP_FILE, (Serializable)this.mCropImageFile);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        Bundle bundle = savedInstanceState;
        this.mCropImageFile = (File)(bundle != null ? bundle.getSerializable(STATE_CROP_FILE) : null);
    }

    public final boolean isCropEnabled() {
        return this.mCrop;
    }

    public final void startIntent(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.cropImage(uri);
    }

    private final void cropImage(Uri uri) throws IOException {
        String extension;
        block8: {
            block7: {
                extension = FileUtil.INSTANCE.getImageExtension(uri);
                this.mCropImageFile = FileUtil.INSTANCE.getImageFile(this.mFileDir, extension);
                if (this.mCropImageFile == null) break block7;
                File file = this.mCropImageFile;
                Intrinsics.checkNotNull((Object)file);
                if (file.exists()) break block8;
            }
            Log.e((String)TAG, (String)"Failed to create crop image file");
            this.setError(R.string.error_failed_to_crop_image);
            return;
        }
        UCrop.Options options = new UCrop.Options();
        options.setCompressionFormat(FileUtil.INSTANCE.getCompressFormat(extension));
        UCrop uCrop = UCrop.of((Uri)uri, (Uri)Uri.fromFile((File)this.mCropImageFile)).withOptions(options);
        if (this.mCropAspectX > 0.0f && this.mCropAspectY > 0.0f) {
            uCrop.withAspectRatio(this.mCropAspectX, this.mCropAspectY);
        }
        if (this.mMaxWidth > 0 && this.mMaxHeight > 0) {
            uCrop.withMaxResultSize(this.mMaxWidth, this.mMaxHeight);
        }
        try {
            uCrop.start((Activity)this.getActivity(), 69);
        }
        catch (ActivityNotFoundException ex) {
            this.setError("uCrop not specified in manifest file.Add UCropActivity in Manifest<activity\n    android:name=\"com.yalantis.ucrop.UCropActivity\"\n    android:screenOrientation=\"portrait\"\n    android:theme=\"@style/Theme.AppCompat.Light.NoActionBar\"/>");
            ex.printStackTrace();
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 69) {
            if (resultCode == -1) {
                this.handleResult(this.mCropImageFile);
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult(File file) {
        if (file != null) {
            ImagePickerActivity imagePickerActivity = this.getActivity();
            Uri uri = Uri.fromFile((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(file)");
            imagePickerActivity.setCropImage(uri);
        } else {
            this.setError(R.string.error_failed_to_crop_image);
        }
    }

    @Override
    protected void onFailure() {
        this.delete();
    }

    public final void delete() {
        File file = this.mCropImageFile;
        if (file != null) {
            file.delete();
        }
        this.mCropImageFile = null;
    }

    public CropProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        super(activity);
        Intent intent = activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"activity.intent.extras ?: Bundle()");
        Bundle bundle2 = bundle;
        this.mMaxWidth = bundle2.getInt("extra.max_width", 0);
        this.mMaxHeight = bundle2.getInt("extra.max_height", 0);
        this.mCrop = bundle2.getBoolean("extra.crop", false);
        this.mCropAspectX = bundle2.getFloat("extra.crop_x", 0.0f);
        this.mCropAspectY = bundle2.getFloat("extra.crop_y", 0.0f);
        String fileDir = bundle2.getString("extra.save_directory");
        this.mFileDir = this.getFileDir(fileDir);
    }

    static {
        Companion = new Companion(null);
        TAG = CropProvider.class.getSimpleName();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CropProvider$Companion;", "", "()V", "STATE_CROP_FILE", "", "TAG", "kotlin.jvm.PlatformType", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

