/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import com.github.dhaval2404.imagepicker.ImagePickerActivity$WhenMappings;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.constant.ImageProvider;
import com.github.dhaval2404.imagepicker.provider.CameraProvider;
import com.github.dhaval2404.imagepicker.provider.CompressionProvider;
import com.github.dhaval2404.imagepicker.provider.CropProvider;
import com.github.dhaval2404.imagepicker.provider.GalleryProvider;
import com.github.dhaval2404.imagepicker.util.FileUriUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0015\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J+\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u001aJ\u000e\u0010&\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\u0010\u0010'\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u0010(\u001a\u00020\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "mCameraProvider", "Lcom/github/dhaval2404/imagepicker/provider/CameraProvider;", "mCompressionProvider", "Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider;", "mCropProvider", "Lcom/github/dhaval2404/imagepicker/provider/CropProvider;", "mGalleryProvider", "Lcom/github/dhaval2404/imagepicker/provider/GalleryProvider;", "loadBundle", "", "savedInstanceState", "Landroid/os/Bundle;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCreate", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onSaveInstanceState", "outState", "setCompressedImage", "uri", "Landroid/net/Uri;", "setCropImage", "setError", "message", "setImage", "setResult", "setResultCancel", "Companion", "imagepicker_release"})
public final class ImagePickerActivity
extends AppCompatActivity {
    private GalleryProvider mGalleryProvider;
    private CameraProvider mCameraProvider;
    private CropProvider mCropProvider;
    private CompressionProvider mCompressionProvider;
    private static final String TAG = "image_picker";
    public static final Companion Companion = new Companion(null);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loadBundle(savedInstanceState);
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            cameraProvider.onSaveInstanceState(outState);
        }
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        cropProvider.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void loadBundle(Bundle savedInstanceState) {
        ImageProvider provider;
        CropProvider cropProvider = this.mCropProvider = new CropProvider(this);
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        cropProvider.onRestoreInstanceState(savedInstanceState);
        this.mCompressionProvider = new CompressionProvider(this);
        Intent intent = this.getIntent();
        ImageProvider imageProvider = provider = (ImageProvider)((Object)(intent != null ? intent.getSerializableExtra("extra.image_provider") : null));
        if (imageProvider != null) {
            switch (ImagePickerActivity$WhenMappings.$EnumSwitchMapping$0[imageProvider.ordinal()]) {
                case 1: {
                    this.mGalleryProvider = new GalleryProvider(this);
                    Bundle bundle = savedInstanceState;
                    if (bundle != null) {
                        return;
                    }
                    GalleryProvider galleryProvider = this.mGalleryProvider;
                    if (galleryProvider == null) return;
                    galleryProvider.startIntent();
                    bundle = Unit.INSTANCE;
                    return;
                }
                case 2: {
                    Bundle bundle;
                    CameraProvider cameraProvider = this.mCameraProvider = new CameraProvider(this);
                    if (cameraProvider != null) {
                        cameraProvider.onRestoreInstanceState(savedInstanceState);
                    }
                    if ((bundle = savedInstanceState) != null) {
                        return;
                    }
                    CameraProvider cameraProvider2 = this.mCameraProvider;
                    if (cameraProvider2 == null) return;
                    cameraProvider2.startIntent();
                    bundle = Unit.INSTANCE;
                    return;
                }
            }
        }
        Log.e((String)TAG, (String)"Image provider can not be null");
        String string2 = this.getString(R.string.error_task_cancelled);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.error_task_cancelled)");
        this.setError(string2);
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            CameraProvider cameraProvider = this.mCameraProvider;
            if (cameraProvider == null) break block0;
            cameraProvider.onRequestPermissionsResult(requestCode);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            cameraProvider.onActivityResult(requestCode, resultCode, data);
        }
        GalleryProvider galleryProvider = this.mGalleryProvider;
        if (galleryProvider != null) {
            galleryProvider.onActivityResult(requestCode, resultCode, data);
        }
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        cropProvider.onActivityResult(requestCode, resultCode, data);
    }

    public void onBackPressed() {
        this.setResultCancel();
    }

    public final void setImage(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        if (cropProvider.isCropEnabled()) {
            CropProvider cropProvider2 = this.mCropProvider;
            if (cropProvider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
            }
            cropProvider2.startIntent(uri);
        } else {
            CompressionProvider compressionProvider = this.mCompressionProvider;
            if (compressionProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
            }
            if (compressionProvider.isCompressionRequired(uri)) {
                CompressionProvider compressionProvider2 = this.mCompressionProvider;
                if (compressionProvider2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
                }
                compressionProvider2.compress(uri);
            } else {
                this.setResult(uri);
            }
        }
    }

    public final void setCropImage(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            cameraProvider.delete();
        }
        CompressionProvider compressionProvider = this.mCompressionProvider;
        if (compressionProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
        }
        if (compressionProvider.isCompressionRequired(uri)) {
            CompressionProvider compressionProvider2 = this.mCompressionProvider;
            if (compressionProvider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
            }
            compressionProvider2.compress(uri);
        } else {
            this.setResult(uri);
        }
    }

    public final void setCompressedImage(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            cameraProvider.delete();
        }
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        cropProvider.delete();
        this.setResult(uri);
    }

    private final void setResult(Uri uri) {
        Intent intent = new Intent();
        intent.setData(uri);
        intent.putExtra("extra.file_path", FileUriUtils.INSTANCE.getRealPath((Context)this, uri));
        this.setResult(-1, intent);
        this.finish();
    }

    public final void setResultCancel() {
        this.setResult(0, Companion.getCancelledIntent$imagepicker_release((Context)this));
        this.finish();
    }

    public final void setError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intent intent = new Intent();
        intent.putExtra("extra.error", message);
        this.setResult(64, intent);
        this.finish();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePickerActivity$Companion;", "", "()V", "TAG", "", "getCancelledIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "getCancelledIntent$imagepicker_release", "imagepicker_release"})
    public static final class Companion {
        @NotNull
        public final Intent getCancelledIntent$imagepicker_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent();
            String string2 = context.getString(R.string.error_task_cancelled);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.string.error_task_cancelled)");
            String message = string2;
            intent.putExtra("extra.error", message);
            return intent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

