/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.os.Bundle;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.ExifDataCopier;
import com.github.dhaval2404.imagepicker.util.FileUriUtils;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import com.github.dhaval2404.imagepicker.util.ImageUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0003R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mFileDir", "Ljava/io/File;", "mMaxFileSize", "", "mMaxHeight", "", "mMaxWidth", "mOriginalFile", "applyCompression", "file", "attempt", "compress", "", "getImageSize", "", "getSizeDiff", "handleResult", "isCompressEnabled", "", "isCompressionRequired", "resolutionList", "", "startCompression", "startCompressionWorker", "Companion", "imagepicker_release"})
public final class CompressionProvider
extends BaseProvider {
    private final int mMaxWidth;
    private final int mMaxHeight;
    private final long mMaxFileSize;
    private File mOriginalFile;
    private File mFileDir;
    private static final String TAG;
    public static final Companion Companion;

    public final boolean isCompressEnabled() {
        return this.mMaxFileSize > 0L;
    }

    public final boolean isCompressionRequired(@NotNull File file) {
        boolean status;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean bl = status = this.isCompressEnabled() && this.getSizeDiff(file) > 0L;
        if (!status && this.mMaxWidth > 0 && this.mMaxHeight > 0) {
            int[] sizes = this.getImageSize(file);
            return sizes[0] > this.mMaxWidth || sizes[1] > this.mMaxHeight;
        }
        return status;
    }

    private final long getSizeDiff(File file) {
        return file.length() - this.mMaxFileSize;
    }

    public final void compress(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.startCompressionWorker(file);
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private final void startCompressionWorker(File file) {
        this.mOriginalFile = file;
        new AsyncTask<File, Void, File>(this){
            final /* synthetic */ CompressionProvider this$0;

            @Nullable
            protected File doInBackground(File ... params) {
                Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
                return CompressionProvider.access$startCompression(this.this$0, params[0]);
            }

            protected void onPostExecute(@Nullable File file) {
                super.onPostExecute((Object)file);
                if (file != null) {
                    CompressionProvider.access$handleResult(this.this$0, file);
                } else {
                    this.this$0.setError(R.string.error_failed_to_compress_image);
                }
            }
            {
                this.this$0 = $outer;
            }
        }.execute((Object[])new File[]{file});
    }

    private final File startCompression(File file) {
        File newFile = null;
        int attempt = 0;
        int lastAttempt = 0;
        do {
            File file2 = newFile;
            if (file2 != null) {
                file2.delete();
            }
            newFile = this.applyCompression(file, attempt);
            if (newFile == null) {
                return attempt > 0 ? this.applyCompression(file, lastAttempt) : null;
            }
            lastAttempt = attempt++;
            if (this.mMaxFileSize <= 0L) continue;
            long diff = this.getSizeDiff(newFile);
            attempt += diff > (long)0x100000 ? 3 : (diff > (long)512000 ? 2 : 1);
        } while (this.isCompressionRequired(newFile));
        ExifDataCopier.INSTANCE.copyExif(file, newFile);
        return newFile;
    }

    private final File applyCompression(File file, int attempt) {
        File file2;
        String extension;
        File compressFile;
        List<int[]> resList = this.resolutionList();
        if (attempt >= resList.size()) {
            return null;
        }
        int[] resolution = resList.get(attempt);
        int maxWidth = resolution[0];
        int maxHeight = resolution[1];
        if (this.mMaxWidth > 0 && this.mMaxHeight > 0 && (maxWidth > this.mMaxWidth || maxHeight > this.mMaxHeight)) {
            maxHeight = this.mMaxHeight;
            maxWidth = this.mMaxWidth;
        }
        Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
        int quality = 100;
        String string2 = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.absolutePath");
        if (StringsKt.endsWith$default((String)string2, (String)".png", (boolean)false, (int)2, null)) {
            format = Bitmap.CompressFormat.PNG;
            quality = 100;
        }
        if ((compressFile = FileUtil.INSTANCE.getImageFile(this.mFileDir, extension = FileUriUtils.INSTANCE.getImageExtension(file))) != null) {
            float f = maxWidth;
            float f2 = maxHeight;
            String string3 = compressFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"compressFile.absolutePath");
            file2 = ImageUtil.INSTANCE.compressImage(file, f, f2, format, quality, string3);
        } else {
            file2 = null;
        }
        return file2;
    }

    private final List<int[]> resolutionList() {
        return CollectionsKt.listOf((Object[])new int[][]{{2448, 3264}, {2008, 3032}, {1944, 2580}, {1680, 2240}, {1536, 2048}, {1200, 1600}, {1024, 1392}, {960, 1280}, {768, 1024}, {600, 800}, {480, 640}, {240, 320}, {120, 160}, {60, 80}, {30, 40}});
    }

    private final void handleResult(File file) {
        this.getActivity().setCompressedImage(file);
    }

    private final int[] getImageSize(File file) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public CompressionProvider(@NotNull ImagePickerActivity activity) {
        block1: {
            String fileDir;
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            super(activity);
            Intent intent = activity.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"activity.intent");
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                bundle = new Bundle();
            }
            Bundle bundle2 = bundle;
            this.mMaxWidth = bundle2.getInt("extra.max_width", 0);
            this.mMaxHeight = bundle2.getInt("extra.max_height", 0);
            this.mMaxFileSize = bundle2.getLong("extra.image_max_size", 0L);
            String string2 = fileDir = bundle2.getString("extra.save_directory");
            if (string2 == null) break block1;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.mFileDir = new File(it);
        }
    }

    static {
        Companion = new Companion(null);
        TAG = CompressionProvider.class.getSimpleName();
    }

    public static final /* synthetic */ File access$startCompression(CompressionProvider $this, File file) {
        return $this.startCompression(file);
    }

    public static final /* synthetic */ void access$handleResult(CompressionProvider $this, File file) {
        $this.handleResult(file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "imagepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

