/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import com.github.dhaval2404.imagepicker.R;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001b\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/github/dhaval2404/imagepicker/util/IntentUtils;", "", "()V", "getCameraIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getGalleryDocumentIntent", "mimeTypes", "", "", "([Ljava/lang/String;)Landroid/content/Intent;", "getGalleryIntent", "(Landroid/content/Context;[Ljava/lang/String;)Landroid/content/Intent;", "getLegacyGalleryPickIntent", "isCameraHardwareAvailable", "", "applyImageTypes", "(Landroid/content/Intent;[Ljava/lang/String;)Landroid/content/Intent;", "imagepicker-support_release"})
public final class IntentUtils {
    public static final IntentUtils INSTANCE;

    @NotNull
    public final Intent getGalleryIntent(@NotNull Context context, @NotNull String[] mimeTypes) {
        Intent intent;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)mimeTypes, (String)"mimeTypes");
        if (Build.VERSION.SDK_INT >= 19 && (intent = this.getGalleryDocumentIntent(mimeTypes)).resolveActivity(context.getPackageManager()) != null) {
            return intent;
        }
        return this.getLegacyGalleryPickIntent(mimeTypes);
    }

    private final Intent getGalleryDocumentIntent(String[] mimeTypes) {
        Intent intent = this.applyImageTypes(new Intent("android.intent.action.OPEN_DOCUMENT"), mimeTypes);
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }

    private final Intent getLegacyGalleryPickIntent(String[] mimeTypes) {
        return this.applyImageTypes(new Intent("android.intent.action.PICK"), mimeTypes);
    }

    private final Intent applyImageTypes(@NotNull Intent $receiver, String[] mimeTypes) {
        String[] stringArray;
        $receiver.setType("image/*");
        String[] stringArray2 = stringArray = mimeTypes;
        if (!(stringArray2.length == 0)) {
            $receiver.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
        }
        return $receiver;
    }

    @Nullable
    public final Intent getCameraIntent(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = context.getPackageName() + context.getString(R.string.image_picker_provider_authority_suffix);
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            intent.putExtra("output", (Parcelable)photoURI);
        } else {
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        }
        return intent;
    }

    public final boolean isCameraHardwareAvailable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return context.getPackageManager().hasSystemFeature("android.hardware.camera.any");
    }

    private IntentUtils() {
    }

    static {
        IntentUtils intentUtils;
        INSTANCE = intentUtils = new IntentUtils();
    }
}

