/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Build;
import android.support.media.ExifInterface;
import com.github.dhaval2404.imagepicker.util.ImageUtil$WhenMappings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/github/dhaval2404/imagepicker/util/ImageUtil;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "canUseForInBitmap", "", "candidate", "Landroid/graphics/Bitmap;", "targetOptions", "compressImage", "Ljava/io/File;", "imageFile", "", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "destinationPath", "", "decodeSampledBitmapFromFile", "getBytesPerPixel", "config", "Landroid/graphics/Bitmap$Config;", "imagepicker-support_release"})
public final class ImageUtil {
    public static final ImageUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File compressImage(@NotNull File imageFile, float reqWidth, float reqHeight, @NotNull Bitmap.CompressFormat compressFormat, int quality, @NotNull String destinationPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)compressFormat, (String)"compressFormat");
        Intrinsics.checkParameterIsNotNull((Object)destinationPath, (String)"destinationPath");
        FileOutputStream fileOutputStream = null;
        File file = new File(destinationPath).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            fileOutputStream = new FileOutputStream(destinationPath);
            Bitmap bitmap = this.decodeSampledBitmapFromFile(imageFile, reqWidth, reqHeight);
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            bitmap.compress(compressFormat, quality, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            throw throwable;
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        return new File(destinationPath);
    }

    private final Bitmap decodeSampledBitmapFromFile(File imageFile, float reqWidth, float reqHeight) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bmp = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float imgRatio = (float)actualWidth / (float)actualHeight;
        float maxRatio = reqWidth / reqHeight;
        if ((float)actualHeight > reqHeight || (float)actualWidth > reqWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = reqHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = (int)reqHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = reqWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = (int)reqWidth;
            } else {
                actualHeight = (int)reqHeight;
                actualWidth = (int)reqWidth;
            }
        }
        options.inSampleSize = this.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        if (bmp != null && this.canUseForInBitmap(bmp, options)) {
            options.inMutable = true;
            options.inBitmap = bmp;
        }
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        Bitmap scaledBitmap = null;
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Bitmap bitmap = scaledBitmap;
        if (bitmap == null) {
            Intrinsics.throwNpe();
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.setMatrix(scaleMatrix);
        Bitmap bitmap2 = bmp;
        if (bitmap2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawBitmap(bitmap2, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        bmp.recycle();
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            if (orientation == 6) {
                matrix.postRotate(90.0f);
            } else if (orientation == 3) {
                matrix.postRotate(180.0f);
            } else if (orientation == 8) {
                matrix.postRotate(270.0f);
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scaledBitmap;
    }

    private final int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize *= 2;
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private final boolean canUseForInBitmap(Bitmap candidate, BitmapFactory.Options targetOptions) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 19) {
            int width = targetOptions.outWidth / targetOptions.inSampleSize;
            int height = targetOptions.outHeight / targetOptions.inSampleSize;
            Bitmap.Config config = candidate.getConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"candidate.config");
            int byteCount = width * height * this.getBytesPerPixel(config);
            bl = byteCount <= candidate.getAllocationByteCount();
        } else {
            bl = candidate.getWidth() == targetOptions.outWidth && candidate.getHeight() == targetOptions.outHeight && targetOptions.inSampleSize == 1;
        }
        return bl;
    }

    private final int getBytesPerPixel(Bitmap.Config config) {
        int n;
        switch (ImageUtil$WhenMappings.$EnumSwitchMapping$0[config.ordinal()]) {
            case 1: {
                n = 4;
                break;
            }
            case 2: 
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private ImageUtil() {
    }

    static {
        ImageUtil imageUtil;
        INSTANCE = imageUtil = new ImageUtil();
    }
}

