/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.os.Environment;
import android.os.StatFs;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUtil;", "", "()V", "getCameraFile", "Ljava/io/File;", "getFreeSpace", "", "file", "getTimestamp", "", "imagepicker-support_release"})
public final class FileUtil {
    public static final FileUtil INSTANCE;

    @Nullable
    public final File getCameraFile() {
        try {
            String imageFileName = "IMG_" + this.getTimestamp() + ".jpg";
            File storageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), "Camera");
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            File file = new File(storageDir, imageFileName);
            file.createNewFile();
            return file;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private final String getTimestamp() {
        String timeFormat = "yyyyMMdd_HHmmssSSS";
        String string2 = new SimpleDateFormat(timeFormat, Locale.getDefault()).format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(timeFor\u2026Default()).format(Date())");
        return string2;
    }

    public final long getFreeSpace(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        StatFs stat = new StatFs(file.getPath());
        long availBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return availBlocks * blockSize;
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

