/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.form_validation.validation;

import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import com.github.dhaval2404.form_validation.adapter.CheckBoxAdapter;
import com.github.dhaval2404.form_validation.adapter.TextInputLayoutAdapter;
import com.github.dhaval2404.form_validation.adapter.TextViewAdapter;
import com.github.dhaval2404.form_validation.adapter.ViewDataAdapter;
import com.github.dhaval2404.form_validation.rule.BaseRule;
import com.github.dhaval2404.form_validation.validation.ValidationError;
import com.google.android.material.textfield.TextInputLayout;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0012\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0002J\u001a\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J \u0010\u001c\u001a\u00020\u00002\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u0004J\u0016\u0010\u001e\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010 \u001a\u00020!R\"\u0010\u0003\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\b\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u00010\tj\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\u0001`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\r\u001a*\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00050\tj\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0005`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/dhaval2404/form_validation/validation/FormValidator;", "", "()V", "mErrorListener", "Lkotlin/Function1;", "", "Lcom/github/dhaval2404/form_validation/validation/ValidationError;", "", "mRegistry", "Ljava/util/LinkedHashMap;", "Ljava/lang/Class;", "Landroid/view/View;", "Lkotlin/collections/LinkedHashMap;", "mValidationFields", "Lcom/github/dhaval2404/form_validation/rule/BaseRule;", "addField", "view", "rule", "", "(Landroid/view/View;[Lcom/github/dhaval2404/form_validation/rule/BaseRule;)Lcom/github/dhaval2404/form_validation/validation/FormValidator;", "applyValidation", "getText", "", "getViewDataAdapter", "Lcom/github/dhaval2404/form_validation/adapter/ViewDataAdapter;", "clazz", "setError", "error", "setErrorListener", "errorListener", "setErrors", "validations", "validate", "", "Companion", "form_validation_release"})
public final class FormValidator {
    private final LinkedHashMap<View, List<BaseRule>> mValidationFields = new LinkedHashMap();
    private final LinkedHashMap<Class<? extends View>, Object> mRegistry = new LinkedHashMap();
    private Function1<? super List<ValidationError>, Unit> mErrorListener;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FormValidator addField(@NotNull View view, BaseRule ... rule) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)rule, (String)"rule");
        ((Map)this.mValidationFields).put(view, ArraysKt.toList((Object[])rule));
        return this;
    }

    @NotNull
    public final FormValidator setErrorListener(@NotNull Function1<? super List<ValidationError>, Unit> errorListener) {
        Intrinsics.checkParameterIsNotNull(errorListener, (String)"errorListener");
        this.mErrorListener = errorListener;
        return this;
    }

    public final boolean validate() {
        List<ValidationError> validations;
        block0: {
            validations = this.applyValidation();
            Function1<? super List<ValidationError>, Unit> function1 = this.mErrorListener;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke(validations);
        }
        return validations.isEmpty();
    }

    private final List<ValidationError> applyValidation() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Map map = this.mValidationFields;
        boolean bl = false;
        for (Map.Entry field : map.entrySet()) {
            String text = this.getText((View)field.getKey());
            boolean status = true;
            for (BaseRule rule : (List)field.getValue()) {
                if (rule.validate(text)) continue;
                View view = (View)field.getKey();
                Context context = ((View)field.getKey()).getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"field.key.context");
                errors.add(new ValidationError(view, rule.getError(context)));
                status = false;
                break;
            }
            if (!status) continue;
            this.setError((View)field.getKey(), null);
        }
        this.setErrors((List<ValidationError>)errors);
        return errors;
    }

    private final void setErrors(List<ValidationError> validations) {
        for (ValidationError validation : validations) {
            this.setError(validation.getView(), validation.getError());
        }
    }

    private final ViewDataAdapter<View> getViewDataAdapter(Class<? extends View> clazz) {
        ViewDataAdapter<View> viewDataAdapter;
        if (this.mRegistry.containsKey(clazz)) {
            Object object = this.mRegistry.get(clazz);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.github.dhaval2404.form_validation.adapter.ViewDataAdapter<android.view.View>");
            }
            return (ViewDataAdapter)object;
        }
        Class<? extends View> parentClass = clazz.getSuperclass();
        if (Intrinsics.areEqual(parentClass, Object.class)) {
            viewDataAdapter = null;
        } else {
            Class<? extends View> clazz2 = parentClass;
            if (clazz2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out android.view.View>");
            }
            viewDataAdapter = this.getViewDataAdapter(clazz2);
        }
        return viewDataAdapter;
    }

    private final String getText(View view) {
        ViewDataAdapter<View> viewDataAdapter = this.getViewDataAdapter(view.getClass());
        return viewDataAdapter != null ? viewDataAdapter.getData(view) : null;
    }

    private final void setError(View view, String error) {
        block0: {
            ViewDataAdapter<View> viewDataAdapter = this.getViewDataAdapter(view.getClass());
            if (viewDataAdapter == null) break block0;
            viewDataAdapter.setError(view, error);
        }
    }

    public FormValidator() {
        ((Map)this.mRegistry).put(CheckBox.class, new CheckBoxAdapter());
        ((Map)this.mRegistry).put(TextView.class, new TextViewAdapter());
        ((Map)this.mRegistry).put(TextInputLayout.class, new TextInputLayoutAdapter());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/github/dhaval2404/form_validation/validation/FormValidator$Companion;", "", "()V", "getInstance", "Lcom/github/dhaval2404/form_validation/validation/FormValidator;", "form_validation_release"})
    public static final class Companion {
        @NotNull
        public final FormValidator getInstance() {
            return new FormValidator();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

