/*
 * Decompiled with CFR 0.152.
 */
package devmike.jade.com;

import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ArrayRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.devmike.pagestepindicator.R;

public class PageStepIndicator
extends View {
    private static final int DEFAULT_STEP_RADIUS = 14;
    private static final int DEFAULT_STOKE_WIDTH = 6;
    private static final int DEFAULT_STEP_COUNT = 4;
    private static final int DEFAULT_BACKGROUND_COLOR = R.color.background_default;
    private static final int DEFAULT_STEP_COLOR = R.color.step_default;
    private static final int DEFAULT_CURRENT_STEP_COLOR = R.color.current_step_default;
    private static final int DEFAULT_INACTIVE_TITLE = R.color.lighter_gray;
    private static final int DEFAULT_TEXT_COLOR = R.color.text_default;
    private static final int DEFAULT_SECONDARY_TEXT_COLOR = R.color.secondary_text_default;
    public static final float DEFAULT_LINE_HEIGHT = 6.0f;
    public static final int DEFAULT_STROKE_ALPHA = 100;
    private static final int DEFAULT_TITLE_SIZE = 14;
    private String[] titles;
    private int radius;
    private int pageStrokeAlpha;
    private int pageTitleId;
    private boolean isTitleClickable;
    private int pageActiveTitleColor;
    private int pageInActiveTitleColor;
    private float titleTextSize;
    private float defaultTitleSize;
    private float mLineHeight;
    private int strokeWidth;
    private int currentStepPosition;
    private int stepsCount = 1;
    private int backgroundColor;
    private int stepColor;
    private int currentColor;
    private int textColor;
    private int secondaryTextColor;
    private int centerY;
    private int startX;
    private int endX;
    private int stepDistance;
    private float offset;
    private int offsetPixel;
    private int pagerScrollState;
    private Paint paint;
    private Paint pStoke;
    private Paint pText;
    private Paint tText;
    private int titleSize;
    private final Rect textBounds = new Rect();
    private OnClickListener onClickListener;
    private float[] hsvCurrent = new float[3];
    private float[] hsvBG = new float[3];
    private float[] hsvProgress = new float[3];
    private boolean clickable = true;
    private boolean withViewpager;
    private ViewPagerOnChangeListener viewPagerChangeListener;
    private boolean disablePageChange;
    private TabLayout.OnTabSelectedListener onTabSelectedListener;

    public PageStepIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public PageStepIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PageStepIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public PageStepIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void setOnClickListener(OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.initAttributes(context, attributeSet);
        this.paint = new Paint();
        this.pStoke = new Paint();
        this.pText = new Paint();
        this.tText = new Paint();
        this.defaultTitleSize = (float)this.radius * 1.2f;
        this.paint.setColor(this.stepColor);
        this.paint.setFlags(1);
        this.paint.setStrokeWidth(this.mLineHeight);
        this.pStoke.setColor(this.stepColor);
        this.pStoke.setStrokeWidth((float)this.strokeWidth);
        this.pStoke.setStyle(Paint.Style.STROKE);
        this.pStoke.setFlags(1);
        this.tText.setTextSize(this.titleTextSize);
        this.tText.setColor(this.pageInActiveTitleColor);
        this.tText.setTextAlign(Paint.Align.CENTER);
        this.tText.setFlags(1);
        this.tText.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
        this.pText.setColor(this.textColor);
        this.pText.setTextSize((float)this.radius * 1.2f);
        this.pText.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        this.pText.setTextAlign(Paint.Align.CENTER);
        this.pText.setFlags(1);
        this.setMinimumHeight(this.radius * 7);
        Color.colorToHSV((int)this.currentColor, (float[])this.hsvCurrent);
        Color.colorToHSV((int)this.backgroundColor, (float[])this.hsvBG);
        Color.colorToHSV((int)this.stepColor, (float[])this.hsvProgress);
        this.initAnimation();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr = context.obtainStyledAttributes(attributeSet, R.styleable.PageStepIndicator, 0, 0);
        if (attr == null) {
            return;
        }
        try {
            this.titleTextSize = (int)attr.getDimension(R.styleable.PageStepIndicator_pgTitleTextSize, this.dp2px(14.0f));
            this.radius = (int)attr.getDimension(R.styleable.PageStepIndicator_pgRadius, this.dp2px(14.0f));
            this.strokeWidth = (int)attr.getDimension(R.styleable.PageStepIndicator_pgStrokeWidth, this.dp2px(6.0f));
            this.stepsCount = attr.getInt(R.styleable.PageStepIndicator_pgStepCount, 4);
            this.mLineHeight = attr.getDimension(R.styleable.PageStepIndicator_pgLineHeight, 6.0f);
            this.stepColor = attr.getColor(R.styleable.PageStepIndicator_pgStepColor, ContextCompat.getColor((Context)context, (int)DEFAULT_STEP_COLOR));
            this.currentColor = attr.getColor(R.styleable.PageStepIndicator_pgCurrentStepColor, ContextCompat.getColor((Context)context, (int)DEFAULT_CURRENT_STEP_COLOR));
            this.backgroundColor = attr.getColor(R.styleable.PageStepIndicator_pgBackgroundColor, ContextCompat.getColor((Context)context, (int)DEFAULT_BACKGROUND_COLOR));
            this.textColor = attr.getColor(R.styleable.PageStepIndicator_pgTextColor, ContextCompat.getColor((Context)context, (int)DEFAULT_TEXT_COLOR));
            this.secondaryTextColor = attr.getColor(R.styleable.PageStepIndicator_pgSecondaryTextColor, ContextCompat.getColor((Context)context, (int)DEFAULT_SECONDARY_TEXT_COLOR));
            this.pageInActiveTitleColor = attr.getColor(R.styleable.PageStepIndicator_pgInActiveTitleColor, ContextCompat.getColor((Context)context, (int)DEFAULT_INACTIVE_TITLE));
            this.pageActiveTitleColor = attr.getColor(R.styleable.PageStepIndicator_pgActiveTitleColor, ContextCompat.getColor((Context)context, (int)DEFAULT_TEXT_COLOR));
            this.pageTitleId = attr.getResourceId(R.styleable.PageStepIndicator_pgTitles, -1);
            this.pageStrokeAlpha = attr.getInt(R.styleable.PageStepIndicator_pgStrokeAlpha, 100);
        }
        finally {
            attr.recycle();
        }
    }

    private void addOnTabSelectedListener(TabLayout.OnTabSelectedListener onTabSelectedListener) {
        this.onTabSelectedListener = onTabSelectedListener;
    }

    @SuppressLint(value={"NewApi"})
    protected float dp2px(float dp) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return Math.round(dp * (float)(displayMetrics.densityDpi / 160));
    }

    public int getStepsCount() {
        return this.stepsCount;
    }

    public void setStepsCount(int stepsCount) {
        this.stepsCount = stepsCount;
        this.invalidate();
    }

    public int getCurrentStepPosition() {
        return this.currentStepPosition;
    }

    public void setCurrentStepPosition(int currentStepPosition) {
        this.currentStepPosition = currentStepPosition;
        this.invalidate();
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public void setupWithViewPager(@NonNull ViewPager viewPager) {
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
        }
        if (this.viewPagerChangeListener == null) {
            this.viewPagerChangeListener = new ViewPagerOnChangeListener(this);
        }
        this.withViewpager = true;
        this.setStepsCount(adapter.getCount());
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.viewPagerChangeListener);
        this.setOnClickListener(new ViewPagerOnSelectedListener(viewPager));
        viewPager.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getActionMasked() == 2) {
                    ((ViewPager)v).addOnPageChangeListener((ViewPager.OnPageChangeListener)PageStepIndicator.this.viewPagerChangeListener);
                    PageStepIndicator.this.disablePageChange = false;
                }
                return false;
            }
        });
        if (adapter.getCount() > 0) {
            int curItem = viewPager.getCurrentItem();
            if (this.getCurrentStepPosition() != curItem) {
                this.setCurrentStepPosition(curItem);
                this.invalidate();
            }
        }
    }

    public void setTitles(@ArrayRes int id) {
        this.pageTitleId = id;
    }

    public void setTitles(String[] titles) {
        this.titles = titles;
    }

    protected void onDraw(Canvas canvas) {
        int pointOffset;
        int drawOffset;
        int i;
        if (this.stepsCount <= 1) {
            this.setVisibility(8);
            return;
        }
        super.onDraw(canvas);
        int pointX = this.startX;
        for (i = 0; i < this.stepsCount - 1; ++i) {
            if (i < this.currentStepPosition) {
                this.paint.setColor(this.stepColor);
                canvas.drawLine((float)pointX, (float)this.centerY, (float)(pointX + this.stepDistance), (float)this.centerY, this.paint);
            } else if (i == this.currentStepPosition) {
                this.paint.setColor(this.backgroundColor);
                canvas.drawLine((float)pointX, (float)this.centerY, (float)(pointX + this.stepDistance), (float)this.centerY, this.paint);
            } else {
                this.paint.setColor(this.backgroundColor);
                canvas.drawLine((float)pointX, (float)this.centerY, (float)(pointX + this.stepDistance), (float)this.centerY, this.paint);
            }
            pointX += this.stepDistance;
        }
        if (this.offsetPixel != 0 && this.pagerScrollState == 1 && (drawOffset = (pointOffset = this.startX + this.currentStepPosition * this.stepDistance) + this.offsetPixel) >= this.startX && drawOffset <= this.endX) {
            if (this.offsetPixel < 0) {
                this.paint.setColor(this.backgroundColor);
            } else {
                this.paint.setColor(this.stepColor);
            }
            canvas.drawLine((float)pointOffset, (float)this.centerY, (float)drawOffset, (float)this.centerY, this.paint);
        }
        pointX = this.startX;
        for (i = 0; i < this.stepsCount; ++i) {
            if (i < this.currentStepPosition) {
                this.paint.setColor(this.stepColor);
                canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.paint);
                if (i == this.currentStepPosition - 1 && this.offsetPixel < 0 && this.pagerScrollState == 1) {
                    this.pStoke.setAlpha(this.pageStrokeAlpha);
                    this.pStoke.setStrokeWidth((float)(this.strokeWidth - Math.round((float)this.strokeWidth * this.offset)));
                    canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.pStoke);
                }
                this.pText.setColor(this.secondaryTextColor);
                this.tText.setColor(this.pageInActiveTitleColor);
                this.animateView(this.tText, this.pageActiveTitleColor, this.pageInActiveTitleColor, canvas);
            } else if (i == this.currentStepPosition) {
                if (this.offsetPixel == 0 || this.pagerScrollState == 0) {
                    this.paint.setColor(this.currentColor);
                    this.pStoke.setStrokeWidth((float)Math.round(this.strokeWidth));
                    this.pStoke.setAlpha(this.pageStrokeAlpha);
                } else if (this.offsetPixel < 0) {
                    this.pStoke.setStrokeWidth((float)Math.round((float)this.strokeWidth * this.offset));
                    this.pStoke.setAlpha(Math.round(this.offset * 11.0f));
                    this.paint.setColor(this.getColorToBG(this.offset));
                } else {
                    this.paint.setColor(this.getColorToProgress(this.offset));
                    this.pStoke.setStrokeWidth((float)(this.strokeWidth - Math.round((float)this.strokeWidth * this.offset)));
                    this.pStoke.setAlpha(255 - Math.round(this.offset * (float)this.pageStrokeAlpha));
                }
                canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.paint);
                canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.pStoke);
                this.pText.setColor(this.textColor);
                this.tText.setColor(this.pageActiveTitleColor);
                this.animateView(this.tText, this.pageInActiveTitleColor, this.pageActiveTitleColor, canvas);
            } else {
                this.paint.setColor(this.backgroundColor);
                canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.paint);
                this.pText.setColor(this.secondaryTextColor);
                this.tText.setColor(this.pageInActiveTitleColor);
                this.animateView(this.tText, this.pageActiveTitleColor, this.pageInActiveTitleColor, canvas);
                if (i == this.currentStepPosition + 1 && this.offsetPixel > 0 && this.pagerScrollState == 1) {
                    this.pStoke.setStrokeWidth((float)Math.round((float)this.strokeWidth * this.offset));
                    this.pStoke.setAlpha(Math.round(this.offset * (float)this.pageStrokeAlpha));
                    canvas.drawCircle((float)pointX, (float)this.centerY, (float)this.radius, this.pStoke);
                }
            }
            if (this.pageTitleId != -1) {
                this.titles = this.getContext().getResources().getStringArray(this.pageTitleId);
                this.drawTextBottom(canvas, this.tText, this.titles[i], pointX, (float)this.getHeight() - this.titleTextSize);
            }
            this.drawTextCentred(canvas, this.pText, String.valueOf(i + 1), pointX, this.centerY);
            pointX += this.stepDistance;
        }
    }

    private void initAnimation() {
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(7500L);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
    }

    private void animateView(Paint target, @ColorInt int defaultColor, @ColorInt int toColor, Canvas canvas) {
        ObjectAnimator animator = ObjectAnimator.ofObject((Object)target, (String)"color", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{toColor, defaultColor});
        animator.setDuration(2000L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animFrac = animation.getAnimatedFraction();
                PageStepIndicator.this.tText.setColor(-16777216);
                PageStepIndicator.this.invalidate();
            }
        });
        animator.start();
    }

    private void drawTextCentred(Canvas canvas, Paint paint, String text, float cx, float cy) {
        paint.getTextBounds(text, 0, text.length(), this.textBounds);
        canvas.drawText(text, cx, cy - this.textBounds.exactCenterY(), paint);
    }

    private void drawTextBottom(Canvas canvas, Paint paint, String text, float cx, float cy) {
        paint.getTextBounds(text, 0, text.length(), this.textBounds);
        Path path = new Path();
        canvas.drawText(text, cx, cy - this.textBounds.exactCenterY(), paint);
    }

    private int getColorToBG(float offset) {
        offset = Math.abs(offset);
        float[] hsv = new float[]{this.hsvBG[0] + (this.hsvCurrent[0] - this.hsvBG[0]) * offset, this.hsvBG[1] + (this.hsvCurrent[1] - this.hsvBG[1]) * offset, this.hsvBG[2] + (this.hsvCurrent[2] - this.hsvBG[2]) * offset};
        return Color.HSVToColor((float[])hsv);
    }

    private int getColorToProgress(float offset) {
        offset = Math.abs(offset);
        float[] hsv = new float[]{this.hsvCurrent[0] + (this.hsvProgress[0] - this.hsvCurrent[0]) * offset, this.hsvCurrent[1] + (this.hsvProgress[1] - this.hsvCurrent[1]) * offset, this.hsvCurrent[2] + (this.hsvProgress[2] - this.hsvCurrent[2]) * offset};
        return Color.HSVToColor((float[])hsv);
    }

    private void setOffset(float offset, int position) {
        this.offset = offset;
        this.offsetPixel = Math.round((float)this.stepDistance * offset);
        if (this.currentStepPosition > position) {
            this.offsetPixel -= this.stepDistance;
        } else {
            this.currentStepPosition = position;
        }
        this.invalidate();
    }

    private void setPagerScrollState(int pagerScrollState) {
        this.pagerScrollState = pagerScrollState;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.clickable) {
            return super.onTouchEvent(event);
        }
        int pointX = this.startX;
        switch (event.getActionMasked()) {
            case 0: {
                int xTouch = (int)event.getX(0);
                int yTouch = (int)event.getY(0);
                for (int i = 0; i < this.stepsCount; ++i) {
                    if (Math.abs(xTouch - pointX) < this.radius + 5 && Math.abs(yTouch - this.centerY) < this.radius + 5) {
                        if (!this.withViewpager) {
                            this.setCurrentStepPosition(i);
                        }
                        if (this.onClickListener != null) {
                            this.onClickListener.onClick(i);
                        }
                    }
                    pointX += this.stepDistance;
                }
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, this.radius * 3);
        this.centerY = this.getHeight() / 2;
        this.startX = this.radius * 2;
        this.endX = this.getWidth() - this.radius * 2;
        this.stepDistance = (this.endX - this.startX) / (this.stepsCount - 1);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerY = this.getHeight() / 2;
        this.startX = this.radius * 2;
        this.endX = this.getWidth() - this.radius * 2;
        this.stepDistance = (this.endX - this.startX) / (this.stepsCount - 1);
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mLineHeight = this.mLineHeight;
        ss.radius = this.radius;
        ss.strokeWidth = this.strokeWidth;
        ss.currentStepPosition = this.currentStepPosition;
        ss.stepsCount = this.stepsCount;
        ss.backgroundColor = this.backgroundColor;
        ss.stepColor = this.stepColor;
        ss.currentColor = this.currentColor;
        ss.textColor = this.textColor;
        ss.secondaryTextColor = this.secondaryTextColor;
        ss.titleTextSize = this.titleSize;
        ss.pageActiveTitleColor = this.pageActiveTitleColor;
        ss.pageInActiveTitleColor = this.pageInActiveTitleColor;
        ss.pageTitleId = this.pageTitleId;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mLineHeight = ss.mLineHeight;
        this.radius = ss.radius;
        this.strokeWidth = ss.strokeWidth;
        this.currentStepPosition = ss.currentStepPosition;
        this.stepsCount = ss.stepsCount;
        this.backgroundColor = ss.backgroundColor;
        this.stepColor = ss.stepColor;
        this.currentColor = ss.currentColor;
        this.textColor = ss.textColor;
        this.secondaryTextColor = ss.secondaryTextColor;
        this.titleTextSize = ss.titleTextSize;
        this.pageActiveTitleColor = ss.pageActiveTitleColor;
        this.pageInActiveTitleColor = ss.pageInActiveTitleColor;
        this.pageTitleId = ss.pageTitleId;
    }

    static class SavedState
    extends View.BaseSavedState {
        int radius;
        float mLineHeight;
        int strokeWidth;
        int currentStepPosition;
        int stepsCount;
        int backgroundColor;
        int stepColor;
        int currentColor;
        int textColor;
        int secondaryTextColor;
        int titleTextSize;
        int pageStrokeAlpha;
        int pageTitleId;
        private boolean isTitleClickable;
        private int pageActiveTitleColor;
        private int pageInActiveTitleColor;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mLineHeight = in.readFloat();
            this.radius = in.readInt();
            this.strokeWidth = in.readInt();
            this.currentStepPosition = in.readInt();
            this.stepsCount = in.readInt();
            this.backgroundColor = in.readInt();
            this.stepColor = in.readInt();
            this.currentColor = in.readInt();
            this.textColor = in.readInt();
            this.secondaryTextColor = in.readInt();
            this.titleTextSize = in.readInt();
            this.pageActiveTitleColor = in.readInt();
            this.pageInActiveTitleColor = in.readInt();
            this.pageStrokeAlpha = in.readInt();
            this.pageTitleId = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.mLineHeight);
            dest.writeInt(this.radius);
            dest.writeInt(this.strokeWidth);
            dest.writeInt(this.currentStepPosition);
            dest.writeInt(this.stepsCount);
            dest.writeInt(this.backgroundColor);
            dest.writeInt(this.stepColor);
            dest.writeInt(this.currentColor);
            dest.writeInt(this.textColor);
            dest.writeInt(this.secondaryTextColor);
            dest.writeInt(this.titleTextSize);
            dest.writeInt(this.pageActiveTitleColor);
            dest.writeInt(this.pageInActiveTitleColor);
            dest.writeInt(this.pageStrokeAlpha);
            dest.writeInt(this.pageTitleId);
        }
    }

    public class ViewPagerOnSelectedListener
    implements OnClickListener {
        private final ViewPager mViewPager;

        public ViewPagerOnSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onClick(int position) {
            PageStepIndicator.this.disablePageChange = true;
            PageStepIndicator.this.setCurrentStepPosition(position);
            this.mViewPager.setCurrentItem(position);
        }
    }

    public class ViewPagerOnChangeListener
    implements ViewPager.OnPageChangeListener {
        private final PageStepIndicator stepIndicator;

        public ViewPagerOnChangeListener(PageStepIndicator stepIndicator) {
            this.stepIndicator = stepIndicator;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (!PageStepIndicator.this.disablePageChange) {
                this.stepIndicator.setOffset(positionOffset, position);
            }
        }

        public void onPageSelected(int position) {
            if (!PageStepIndicator.this.disablePageChange) {
                this.stepIndicator.setCurrentStepPosition(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.stepIndicator.setPagerScrollState(state);
        }
    }

    public static interface OnClickListener {
        public void onClick(int var1);
    }
}

