/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.web;

import cn.devezhao.commons.ObjectUtils;
import cn.devezhao.commons.web.RequestContext;
import cn.devezhao.commons.web.ServletUtils;
import cn.devezhao.commons.web.WebUtils;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestContextImpl
implements RequestContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RequestContextImpl(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public HttpSession getSession() {
        return this.request.getSession();
    }

    @Override
    public Serializable getCurrentUser() {
        return (Serializable)this.getSession().getAttribute(WebUtils.CURRENT_USER);
    }

    @Override
    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    @Override
    public int getIntParameter(String paramName) {
        return ObjectUtils.toInt(this.getParameter(paramName));
    }

    @Override
    public long getLongParameter(String paramName) {
        return ObjectUtils.toLong(this.getParameter(paramName));
    }

    @Override
    public double getDoubleParameter(String paramName) {
        return ObjectUtils.toDouble(this.getParameter(paramName));
    }

    @Override
    public void write(Object value) throws IOException {
        String source = value == null ? "" : value.toString();
        this.response.getWriter().write(source);
    }

    @Override
    public void writeJSON(Object value) throws IOException {
        ServletUtils.setContentType((ServletResponse)this.getResponse(), "application/json");
        this.write(value);
    }

    @Override
    public void writeStatus(int status, Object message) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("status", status);
        if (message != null) {
            map.put("message", message);
        }
        this.writeJSON(JSON.toJSONString(map));
    }
}

