/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.runtime;

import cn.devezhao.commons.runtime.MemoryInformation;
import cn.devezhao.commons.runtime.MemoryInformationBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;

public class RuntimeInformation {
    private final MemoryMXBean memory;
    private final RuntimeMXBean runtime;
    private final OperatingSystemMXBean osMXBean;
    private final ThreadMXBean threadMXBean;
    private long preTime = System.nanoTime();
    private long preUsedTime = 0L;

    public RuntimeInformation() {
        this.memory = ManagementFactory.getMemoryMXBean();
        this.runtime = ManagementFactory.getRuntimeMXBean();
        this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.threadMXBean = ManagementFactory.getThreadMXBean();
    }

    public long getTotalHeapMemory() {
        return this.memory.getHeapMemoryUsage().getMax();
    }

    public long getTotalHeapMemoryUsed() {
        return this.memory.getHeapMemoryUsage().getUsed();
    }

    public long getTotalNonHeapMemory() {
        return this.memory.getNonHeapMemoryUsage().getMax();
    }

    public long getTotalNonHeapMemoryUsed() {
        return this.memory.getNonHeapMemoryUsage().getUsed();
    }

    public long getTotalPermGenMemory() {
        return this.getPermGen().getTotal();
    }

    public long getTotalPermGenMemoryUsed() {
        return this.getPermGen().getUsed();
    }

    public List<MemoryInformation> getMemoryPoolInformation() {
        List<MemoryPoolMXBean> mxBeans = ManagementFactory.getMemoryPoolMXBeans();
        ArrayList<MemoryInformationBean> result = new ArrayList<MemoryInformationBean>(mxBeans.size());
        for (MemoryPoolMXBean mxBean : mxBeans) {
            result.add(new MemoryInformationBean(mxBean));
        }
        return Collections.unmodifiableList(result);
    }

    public String getJvmInputArguments() {
        StringBuilder sb = new StringBuilder();
        for (String argument : this.runtime.getInputArguments()) {
            sb.append(argument).append(" ");
        }
        return sb.toString();
    }

    private MemoryInformation getPermGen() {
        for (MemoryInformation info : this.getMemoryPoolInformation()) {
            String name = info.getName().toLowerCase();
            if (!name.contains("perm gen")) continue;
            return info;
        }
        return new MemoryInformation(){

            @Override
            public String getName() {
                return "";
            }

            @Override
            public long getTotal() {
                return -1L;
            }

            @Override
            public long getUsed() {
                return -1L;
            }

            @Override
            public long getFree() {
                return -1L;
            }
        };
    }

    public double getSystemLoad() {
        return this.osMXBean.getSystemLoadAverage();
    }

    public double getProcessLoad() {
        long totalTime = 0L;
        for (long id : this.threadMXBean.getAllThreadIds()) {
            totalTime += this.threadMXBean.getThreadCpuTime(id);
        }
        long currentTime = System.nanoTime();
        long usedTime = totalTime - this.preUsedTime;
        long totalPassedTime = currentTime - this.preTime;
        this.preTime = currentTime;
        this.preUsedTime = totalTime;
        return (double)usedTime / (double)totalPassedTime / (double)this.osMXBean.getAvailableProcessors() * 100.0;
    }

    public int getServletPort() {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            String port = objectNames.iterator().next().getKeyProperty("port");
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

