/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.identifier;

import cn.devezhao.commons.EncryptUtils;
import java.nio.charset.StandardCharsets;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;

public class ComputerIdentifier {
    public static String generateIdentifier() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
        String vendor = operatingSystem.getManufacturer();
        String processorSerialNumber = computerSystem.getSerialNumber();
        String processorIdentifier = centralProcessor.getProcessorIdentifier().getIdentifier();
        int processors = centralProcessor.getLogicalProcessorCount();
        String delimiter = "#";
        return vendor + delimiter + processorSerialNumber + delimiter + processorIdentifier + delimiter + processors;
    }

    public static String generateIdentifierKey() {
        String id = ComputerIdentifier.generateIdentifier();
        return EncryptUtils.toCRC32HexPadding(id.getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) {
        for (int i = 0; i < 10; ++i) {
            String id = ComputerIdentifier.generateIdentifier();
            System.out.println(id + " = " + ComputerIdentifier.generateIdentifierKey());
        }
    }
}

