/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.http4;

import cn.devezhao.commons.http4.ExecuteHttpMethodException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

@Deprecated
public class HttpClientEx {
    private HttpClient httpClient;
    private String encoding;
    private static final HttpClientEx HTTP_CLIENT_EX = new HttpClientEx();

    public HttpClientEx() {
        this(30000, "utf-8");
    }

    public HttpClientEx(int timeout, String encoding) {
        this.encoding = encoding == null ? "utf-8" : encoding;
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(rc).build();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        return this.execMethod((HttpUriRequest)httpGet);
    }

    public String post(String url, String data) {
        HttpPost httpPost = new HttpPost(url);
        if (data != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(data, this.encoding));
        }
        return this.execMethod((HttpUriRequest)httpPost);
    }

    public String post(String url, Map<String, Object> dataMap) {
        HttpPost httpPost = new HttpPost(url);
        if (dataMap != null && !dataMap.isEmpty()) {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> e : dataMap.entrySet()) {
                if (e.getValue() == null) continue;
                params.add(new BasicNameValuePair(e.getKey(), e.getValue().toString()));
            }
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new ExecuteHttpMethodException("\u8bbe\u7f6e POST \u53c2\u6570\u5931\u8d25", e);
            }
        }
        return this.execMethod((HttpUriRequest)httpPost);
    }

    public String execMethod(HttpUriRequest request) {
        try {
            HttpResponse resp = this.httpClient.execute(request);
            String r = null;
            if (resp.getEntity() != null) {
                r = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)this.encoding);
            }
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new ExecuteHttpMethodException("\u65e0\u6548 HTTP \u72b6\u6001: " + resp.getStatusLine() + (r == null ? "" : ":" + r));
            }
            return r;
        }
        catch (Exception e) {
            throw new ExecuteHttpMethodException(e);
        }
    }

    public byte[] readBinary(String uri, int timeout) {
        HttpGet get = new HttpGet(uri);
        get.setConfig(RequestConfig.custom().setSocketTimeout(timeout).build());
        try {
            HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new ExecuteHttpMethodException("\u65e0\u6548 HTTP \u72b6\u6001: " + resp.getStatusLine());
            }
            return EntityUtils.toByteArray((HttpEntity)resp.getEntity());
        }
        catch (Exception e) {
            throw new ExecuteHttpMethodException(e);
        }
    }

    public static HttpClientEx instance() {
        return HTTP_CLIENT_EX;
    }
}

