/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.devezhao.commons.runtime.MemoryInformation;
import cn.devezhao.commons.runtime.RuntimeInformation;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public final class SystemUtils {
    private static long lastGcTime = 0L;
    private static RuntimeInformation runtimeInformation;

    public static void command(String command) {
        SystemUtils.command(command, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void command(String command, PrintStream stream) {
        block18: {
            if (StringUtils.isBlank((String)command)) {
                return;
            }
            BufferedReader reader = null;
            try {
                Runtime rtx = Runtime.getRuntime();
                Process process = rtx.exec(command);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                if (stream != null) {
                    String str;
                    while ((str = reader.readLine()) != null) {
                        stream.println(str);
                    }
                }
                try {
                    System.out.println("Exit: " + process.waitFor());
                }
                catch (Exception ex) {
                    System.err.println("Processes was interrupted");
                    throw ex;
                }
            }
            catch (Exception ex) {
                if (!command.startsWith("cmd /c")) {
                    SystemUtils.command("cmd /c " + command);
                    break block18;
                }
                throw new RuntimeException("Error executing commond: " + command, ex);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static synchronized void gc() {
        if (System.currentTimeMillis() - lastGcTime < 60000L) {
            return;
        }
        lastGcTime = System.currentTimeMillis();
        try {
            System.gc();
            TimeUnit.SECONDS.sleep(30L);
            System.runFinalization();
            TimeUnit.SECONDS.sleep(30L);
            System.gc();
            TimeUnit.SECONDS.sleep(30L);
            System.runFinalization();
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (Exception exception) {
        }
        finally {
            lastGcTime = System.currentTimeMillis();
        }
    }

    public static long getThreadCount() {
        ThreadGroup group;
        ThreadGroup top = group = Thread.currentThread().getThreadGroup();
        while (group != null) {
            top = group;
            group = group.getParent();
        }
        if (top == null) {
            return 0L;
        }
        int estimatedSize = top.activeCount() * 2;
        Thread[] slackList = new Thread[estimatedSize];
        return top.enumerate(slackList);
    }

    public static synchronized RuntimeInformation getRuntimeInformation() {
        if (runtimeInformation == null) {
            if (!org.apache.commons.lang.SystemUtils.isJavaVersionAtLeast((float)1.5f)) {
                throw new RuntimeException("Java version least 1.5");
            }
            runtimeInformation = new RuntimeInformation();
        }
        return runtimeInformation;
    }

    public static List<MemoryInformation> getMemoryStatistics() {
        return SystemUtils.getMemoryStatistics(false);
    }

    public static List<MemoryInformation> getMemoryStatistics(boolean containsPool) {
        ArrayList<MemoryInformation> stats = new ArrayList<MemoryInformation>();
        final RuntimeInformation runtime = SystemUtils.getRuntimeInformation();
        stats.add(new MemoryInformation(){

            @Override
            public String getName() {
                return "Heap";
            }

            @Override
            public long getUsed() {
                return runtime.getTotalHeapMemoryUsed();
            }

            @Override
            public long getTotal() {
                return runtime.getTotalHeapMemory();
            }

            @Override
            public long getFree() {
                return this.getTotal() - this.getUsed();
            }
        });
        stats.add(new MemoryInformation(){

            @Override
            public String getName() {
                return "PermGen";
            }

            @Override
            public long getUsed() {
                return runtime.getTotalPermGenMemoryUsed();
            }

            @Override
            public long getTotal() {
                return runtime.getTotalPermGenMemory();
            }

            @Override
            public long getFree() {
                return this.getTotal() - this.getUsed();
            }
        });
        stats.add(new MemoryInformation(){

            @Override
            public String getName() {
                return "NonHeap";
            }

            @Override
            public long getUsed() {
                return runtime.getTotalNonHeapMemoryUsed();
            }

            @Override
            public long getTotal() {
                return runtime.getTotalNonHeapMemory();
            }

            @Override
            public long getFree() {
                return this.getTotal() - this.getUsed();
            }
        });
        if (containsPool) {
            stats.addAll(runtime.getMemoryPoolInformation());
        }
        return Collections.unmodifiableList(stats);
    }

    public static void dumpThreads(PrintStream stream) {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Thread thread : traces.keySet()) {
            stream.print(String.format("\nThread[%s@%d,%d,%s]: (state = %s)", new Object[]{thread.getName(), thread.getId(), thread.getPriority(), thread.getThreadGroup().getName(), thread.getState()}));
            for (StackTraceElement stackTraceElement : traces.get(thread)) {
                stream.print("\n\t" + stackTraceElement);
            }
        }
    }

    private SystemUtils() {
    }
}

