/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security.member;

import cn.devezhao.bizz.privileges.Privileges;
import cn.devezhao.bizz.security.member.MemberGroup;
import cn.devezhao.bizz.security.member.User;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Role
extends MemberGroup {
    private static final long serialVersionUID = -8635993188721946096L;
    private final Map<Serializable, Privileges> allPrivileges = new HashMap<Serializable, Privileges>();

    public Role(Serializable identity, String name, boolean disabled) {
        super(identity, name, disabled);
    }

    @Override
    public boolean addMember(Principal user) {
        if (!super.addMember(user)) {
            return false;
        }
        ((User)user).setOwningRole(this);
        return true;
    }

    @Override
    public boolean removeMember(Principal user) {
        if (!super.removeMember(user)) {
            return false;
        }
        ((User)user).setOwningRole(null);
        return true;
    }

    public void addPrivileges(Privileges priv) {
        this.allPrivileges.put(priv.getIdentity(), priv);
    }

    public boolean hasPrivileges(Serializable identity) {
        return this.allPrivileges.containsKey(identity);
    }

    public Privileges getPrivileges(Serializable identity) {
        if (!this.hasPrivileges(identity)) {
            return Privileges.NONE;
        }
        return this.allPrivileges.get(identity);
    }

    public Collection<Privileges> getAllPrivileges() {
        return Collections.unmodifiableCollection(this.allPrivileges.values());
    }
}

