/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.privileges.impl;

import cn.devezhao.bizz.privileges.Permission;
import java.io.Serializable;
import java.util.ArrayList;

public class BizzPermission
implements Permission {
    private static final long serialVersionUID = -3736314513059920238L;
    public static final Permission CREATE = new BizzPermission("C", 1, false);
    public static final Permission DELETE = new BizzPermission("D", 2, true);
    public static final Permission UPDATE = new BizzPermission("U", 4, true);
    public static final Permission READ = new BizzPermission("R", 8, true);
    public static final Permission ASSIGN = new BizzPermission("A", 16, true);
    public static final Permission SHARE = new BizzPermission("S", 32, true);
    public static final Permission NONE = new BizzPermission("N", 0, false);
    private final int mask;
    private final String name;
    private final boolean needGuard;

    public static Permission[] parse(int masks) {
        ArrayList<Permission> bps = new ArrayList<Permission>(3);
        if ((masks & CREATE.getMask()) != 0) {
            bps.add(CREATE);
        }
        if ((masks & DELETE.getMask()) != 0) {
            bps.add(DELETE);
        }
        if ((masks & UPDATE.getMask()) != 0) {
            bps.add(UPDATE);
        }
        if ((masks & READ.getMask()) != 0) {
            bps.add(READ);
        }
        if ((masks & ASSIGN.getMask()) != 0) {
            bps.add(ASSIGN);
        }
        if ((masks & SHARE.getMask()) != 0) {
            bps.add(SHARE);
        }
        return bps.toArray(new Permission[0]);
    }

    public BizzPermission(String name, int mask) {
        this(name, mask, Boolean.FALSE);
    }

    public BizzPermission(String name, int mask, boolean needGuard) {
        this.name = name;
        this.mask = mask;
        this.needGuard = needGuard;
    }

    @Override
    public Serializable getIdentity() {
        return this.getName() + ':' + this.getMask() + ':' + (this.isNeedGuard() ? 1 : 0);
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isNeedGuard() {
        return this.needGuard;
    }

    public String toString() {
        return this.getIdentity() + ":BizzPermission@" + super.hashCode();
    }
}

