/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.privileges.impl;

import cn.devezhao.bizz.privileges.DepthEntry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BizzDepthEntry
implements DepthEntry {
    private static final long serialVersionUID = 7612024724703543451L;
    public static final DepthEntry GLOBAL = new BizzDepthEntry("G", 4, null);
    public static final DepthEntry DEEPDOWN = new BizzDepthEntry("D", 3, GLOBAL);
    public static final DepthEntry LOCAL = new BizzDepthEntry("L", 2, DEEPDOWN);
    public static final DepthEntry PRIVATE = new BizzDepthEntry("P", 1, LOCAL);
    public static final DepthEntry NONE = new BizzDepthEntry("N", 0, PRIVATE);
    private static final Map<Integer, DepthEntry> DEPTH_ENTRIES_BY_MASK = new HashMap<Integer, DepthEntry>(5);
    private final String name;
    private final int mask;
    private DepthEntry next;

    public static DepthEntry parse(int mask) throws IllegalArgumentException {
        DepthEntry de = DEPTH_ENTRIES_BY_MASK.get(mask);
        if (de == null) {
            throw new IllegalArgumentException("No DepthEntry defined: " + mask);
        }
        return de;
    }

    public BizzDepthEntry(String name, int mask, DepthEntry previous) {
        this.name = name;
        this.mask = mask;
        if (previous != null) {
            BizzDepthEntry bde = (BizzDepthEntry)previous;
            if (bde.next != null) {
                throw new IllegalArgumentException("Cannot re-defined next DepthEntry for BizzDepthEnter!");
            }
            bde.next = this;
        }
    }

    @Override
    public Serializable getIdentity() {
        return this.getName() + ':' + this.getMask();
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getIdentity() + ":BizzDepthEntry@" + super.hashCode();
    }

    static {
        DEPTH_ENTRIES_BY_MASK.put(GLOBAL.getMask(), GLOBAL);
        DEPTH_ENTRIES_BY_MASK.put(DEEPDOWN.getMask(), DEEPDOWN);
        DEPTH_ENTRIES_BY_MASK.put(LOCAL.getMask(), LOCAL);
        DEPTH_ENTRIES_BY_MASK.put(PRIVATE.getMask(), PRIVATE);
        DEPTH_ENTRIES_BY_MASK.put(NONE.getMask(), NONE);
    }
}

