/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils.validators;

import android.content.Context;
import android.widget.EditText;
import android.widget.Toast;
import com.resources.utils.validators.FormValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateValidator
extends FormValidator.Validator {
    private static final int BEFORE_DATE_SYSTEM = 1;
    private static final int BEFORE_DATE = 2;
    private static final int AFTER_DATE = 3;
    private static final int EQUAL_DATE = 4;
    private static final int NOT_EQUAL_DATE = 5;
    private final EditText dateEditText;
    private final String dateCompare;
    private final int errorMessage;
    private final int typeValidate;

    public DateValidator(EditText dateEditText, int typeValidate, int errorMessage) {
        this.dateEditText = dateEditText;
        this.errorMessage = errorMessage;
        this.typeValidate = typeValidate;
        this.dateCompare = "";
    }

    public DateValidator(EditText dateEditText, String dateCompare, int typeValidate, int errorMessage) {
        this.dateEditText = dateEditText;
        this.errorMessage = errorMessage;
        this.typeValidate = typeValidate;
        this.dateCompare = dateCompare;
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        try {
            switch (this.typeValidate) {
                case 1: {
                    Date dateSecond = formatDate.parse(formatDate.format(new Date()));
                    Date dateFirst = formatDate.parse(this.dateEditText.getText().toString().trim());
                    if (!dateFirst.equals(dateSecond) && !dateFirst.after(dateSecond)) break;
                    valid = false;
                    break;
                }
                case 2: {
                    Date dateSecond = formatDate.parse(this.dateCompare);
                    Date dateFirst = formatDate.parse(this.dateEditText.getText().toString().trim());
                    valid = dateFirst.before(dateSecond);
                    break;
                }
                case 3: {
                    Date dateSecond = formatDate.parse(this.dateCompare);
                    Date dateFirst = formatDate.parse(this.dateEditText.getText().toString().trim());
                    valid = dateFirst.after(dateSecond);
                    break;
                }
                case 4: {
                    Date dateSecond = formatDate.parse(this.dateCompare);
                    Date dateFirst = formatDate.parse(this.dateEditText.getText().toString().trim());
                    valid = dateFirst.equals(dateSecond);
                    break;
                }
                case 5: {
                    Date dateSecond = formatDate.parse(this.dateCompare);
                    Date dateFirst = formatDate.parse(this.dateEditText.getText().toString().trim());
                    valid = !dateFirst.equals(dateSecond);
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            valid = false;
        }
        return valid;
    }

    @Override
    void showError() {
        Toast.makeText((Context)this.context, (int)this.errorMessage, (int)0).show();
    }

    @Override
    void stopError() {
    }
}

