/*
 * Decompiled with CFR 0.152.
 */
package com.resources.background;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.orhanobut.logger.Logger;
import com.resources.background.BaseDefinition;
import com.resources.background.WSBaseResponseInterface;
import com.resources.background.WSCallback;
import com.resources.utils.ConnectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class BaseWSManager<D extends BaseDefinition> {
    private Context mContext;
    private WSCallback mWSCallback;
    private Call<ResponseBody> mBaseResponseCall;
    private static final List<String> errorRegisters = new ArrayList<String>();

    public BaseWSManager settings(Context context) {
        this.mContext = context;
        return this;
    }

    public BaseWSManager settings(WSCallback WSCallback2) {
        this.mContext = (Context)WSCallback2;
        this.mWSCallback = WSCallback2;
        return this;
    }

    public BaseWSManager settings(Context context, WSCallback WSCallback2) {
        this.mContext = context;
        this.mWSCallback = WSCallback2;
        return this;
    }

    protected abstract D getDefinition();

    protected abstract String getJsonDebug(String var1);

    protected abstract boolean getErrorDebugEnabled();

    protected abstract boolean getDebugEnabled();

    public <R extends WSBaseResponseInterface> R requestWsSync(Class<R> tClass, String webServiceKey, Call<ResponseBody> call) {
        if (this.getDebugEnabled()) {
            Gson gson = new Gson();
            return (R)((WSBaseResponseInterface)gson.fromJson(this.getJsonDebug(webServiceKey), tClass));
        }
        try {
            this.mBaseResponseCall = call;
            Response bodyResponse = this.mBaseResponseCall.execute();
            if (bodyResponse.isSuccessful()) {
                String json = ((ResponseBody)bodyResponse.body()).string();
                Gson gson = new Gson();
                return (R)((WSBaseResponseInterface)gson.fromJson(json, tClass));
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <R extends WSBaseResponseInterface> BaseWSManager requestWs(final Class<R> tClass, final String webServiceKey, Call<ResponseBody> call) {
        if (this.getDebugEnabled()) {
            Gson gson = new Gson();
            WSBaseResponseInterface response = (WSBaseResponseInterface)gson.fromJson(this.getJsonDebug(webServiceKey), tClass);
            Logger.d((Object)webServiceKey);
            Log.d((String)":V", (String)webServiceKey);
            if (this.getErrorDebugEnabled()) {
                if (errorRegisters.contains(webServiceKey)) {
                    this.mWSCallback.onSuccessLoadResponse(webServiceKey, response);
                } else {
                    errorRegisters.add(webServiceKey);
                    this.mWSCallback.onErrorLoadResponse(webServiceKey, "");
                }
            } else {
                this.mWSCallback.onSuccessLoadResponse(webServiceKey, response);
            }
            return this;
        }
        if (ConnectionUtils.isConnected(this.mContext)) {
            this.mWSCallback.onRequestWS(webServiceKey);
            this.mBaseResponseCall = call;
            this.mBaseResponseCall.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    if (response.isSuccessful()) {
                        try {
                            String json = ((ResponseBody)response.body()).string();
                            Gson gson = new Gson();
                            BaseWSManager.this.mWSCallback.onSuccessLoadResponse(webServiceKey, (WSBaseResponseInterface)gson.fromJson(json, tClass));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "");
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                    if (!call.isCanceled()) {
                        BaseWSManager.this.mWSCallback.onErrorLoadResponse(webServiceKey, "");
                    }
                }
            });
        } else {
            this.mWSCallback.onErrorConnection();
        }
        return this;
    }

    public boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public void onDestroy() {
        if (this.mBaseResponseCall != null && this.mBaseResponseCall.isExecuted()) {
            this.mBaseResponseCall.cancel();
        }
    }
}

