/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.gson.Gson;

public class Prefs {
    private static String PREFS_NAME;
    private static Prefs singleton;
    private final SharedPreferences preferences;
    private Context context;

    private Prefs(Context context) {
        this.preferences = context.getSharedPreferences(PREFS_NAME, 0);
    }

    private Prefs(Context context, String library) {
        this.preferences = context.getSharedPreferences(library, 0);
    }

    public static void setDefaultContext(Context context) {
        Prefs.with(context);
    }

    public static Prefs instance() {
        if (singleton == null || Prefs.singleton.context == null) {
            throw new IllegalArgumentException("Call setDefaultContext(context) first");
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prefs with(Context context) {
        if (singleton != null) return singleton;
        Class<Prefs> clazz = Prefs.class;
        synchronized (Prefs.class) {
            if (singleton != null) return singleton;
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            singleton = new Prefs(context);
            Prefs.singleton.context = context.getApplicationContext();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public int integer(String key) {
        return this.preferences.getInt(key, -1);
    }

    public int integer(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public String string(String key) {
        return this.preferences.getString(key, "");
    }

    public String string(String key, String defaultValue) {
        return this.preferences.getString(key, defaultValue);
    }

    public boolean bool(String key) {
        return this.preferences.getBoolean(key, false);
    }

    public boolean bool(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public long number(String key) {
        return this.preferences.getLong(key, -1L);
    }

    public long number(String key, long defaultValue) {
        return this.preferences.getLong(key, defaultValue);
    }

    public Object object(String key, Class<?> fromClass) {
        try {
            String json = this.preferences.getString(key, null);
            if (json != null) {
                Gson gson = new Gson();
                return gson.fromJson(json, fromClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void putInt(String key, int value) {
        this.preferences.edit().putInt(key, value).apply();
    }

    public void putBool(String key, boolean value) {
        this.preferences.edit().putBoolean(key, value).apply();
    }

    public void putString(String key, String value) {
        this.preferences.edit().putString(key, value).apply();
    }

    public void putLong(String key, long value) {
        this.preferences.edit().putLong(key, value).apply();
    }

    public void putObject(String key, Object value, Class<?> fromClass) {
        try {
            Gson gson = new Gson();
            String json = gson.toJson(value, fromClass);
            this.preferences.edit().putString(key, json).apply();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only plain objects are supported");
        }
    }

    public long getLong(String key) {
        return this.preferences.getLong(key, 0L);
    }
}

