/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils.validators;

import android.text.Editable;
import android.text.TextWatcher;
import android.widget.TextView;
import com.resources.utils.validators.FormValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextViewValidator
extends FormValidator.Validator
implements TextWatcher {
    private final TextView textView;
    private final int errorMessage;
    private final Pattern pattern;
    private final int minCharacters;
    private final int maxCharacters;

    public TextViewValidator(TextView textView, String regex, int errorMessage) {
        this.textView = textView;
        this.textView.addTextChangedListener((TextWatcher)this);
        this.errorMessage = errorMessage;
        this.minCharacters = -1;
        this.maxCharacters = -1;
        this.pattern = Pattern.compile(regex);
    }

    public TextViewValidator(TextView textView, int minCharacters, int maxCharacters, int errorMessage) {
        this.textView = textView;
        this.textView.addTextChangedListener((TextWatcher)this);
        this.errorMessage = errorMessage;
        this.minCharacters = minCharacters;
        this.maxCharacters = maxCharacters;
        if (minCharacters < 0) {
            throw new IllegalArgumentException("[EditTextValidator] Minimum number of characters is 0");
        }
        this.pattern = null;
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.minCharacters != -1) {
            boolean bl = valid = this.textView.getText().toString().trim().length() >= this.minCharacters;
        }
        if (this.maxCharacters != -1) {
            valid &= this.maxCharacters >= this.textView.getText().toString().trim().length();
        }
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(this.textView.getText().toString().trim());
            return valid & matcher.matches();
        }
        return valid;
    }

    @Override
    public void showError() {
        this.error(this.errorMessage);
    }

    private void error(Integer message) {
        try {
            this.textView.setError(message != null ? this.context.getString(message.intValue()) : null);
            this.textView.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void stopError() {
        this.error(null);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.textView.setError(null);
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.textView.setError(null);
    }

    public void afterTextChanged(Editable s) {
        this.textView.setError(null);
    }
}

