/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.resources.utils.ExternalStorageReadException;
import com.resources.utils.ExternalStorageWriteException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileUtils {
    public static boolean writeToFile(File file, String content) {
        try {
            if (!file.exists()) {
                boolean created = file.createNewFile();
                Log.d((String)"TAG", (String)("Request deleted: " + created));
            }
            PrintWriter pr = new PrintWriter(new FileOutputStream(file));
            pr.println(content);
            pr.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File validFile(File file) {
        try {
            if (file.exists() && !file.delete()) {
                return null;
            }
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                return null;
            }
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeFileInInternalStorage(Context context, String fileName, byte[] byteArr) throws IOException {
        FileUtils.writeFile(context, context.getFilesDir(), fileName, byteArr);
    }

    public static File readFileFromInternalStorage(Context context, String fileName) throws IOException {
        return FileUtils.readFile(context, context.getFilesDir(), fileName);
    }

    public static void writeFileInCacheStorage(Context context, String fileName, byte[] byteArr) throws IOException {
        FileUtils.writeFile(context, context.getCacheDir(), fileName, byteArr);
    }

    public static File readFileFromCacheStorage(Context context, String fileName) throws IOException {
        return FileUtils.readFile(context, context.getCacheDir(), fileName);
    }

    public static void writeImageFileInExternalStorage(String fileName, byte[] byteArr, String dir) throws ExternalStorageWriteException, IOException {
        File file;
        if (FileUtils.isExternalStorageWritable()) {
            File myDir = new File(Environment.getExternalStorageDirectory() + "/" + dir);
            if (!myDir.exists()) {
                myDir.mkdir();
            }
            if (!(file = new File(myDir + "/" + fileName + ".jpg")).exists()) {
                file.createNewFile();
            }
        } else {
            throw new ExternalStorageWriteException("External storage is not writable!");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byteArr);
        fileOutputStream.close();
    }

    public static String writeFileInExternalStorage(String fileName, byte[] byteArr) throws ExternalStorageWriteException, IOException {
        if (FileUtils.isExternalStorageWritable()) {
            File file;
            File myDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) + "/Tesseract/tessdata/");
            if (!myDir.exists()) {
                boolean bl = myDir.mkdirs();
            }
            if (!(file = new File(myDir + "/" + fileName)).exists()) {
                boolean bl = file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byteArr);
            fileOutputStream.close();
            return file.getPath();
        }
        throw new ExternalStorageWriteException("External storage is not writable!");
    }

    public static byte[] readFileFromExternalStorage(String fileName) throws IOException, ExternalStorageReadException {
        if (!FileUtils.isExternalStorageReadable()) {
            throw new ExternalStorageReadException();
        }
        File file = new File(Environment.getExternalStorageDirectory() + "/" + fileName);
        int size = (int)file.length();
        byte[] byteArr = new byte[size];
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        bufferedInputStream.read(byteArr, 0, byteArr.length);
        bufferedInputStream.close();
        return byteArr;
    }

    private static File readFile(Context context, File dirName, String fileName) throws IOException {
        return new File(dirName, fileName);
    }

    private static void writeFile(Context context, File fileDir, String fileName, byte[] byteArr) throws IOException {
        File file = new File(fileDir, fileName);
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(byteArr);
        outputStream.close();
    }

    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return state.equals("mounted");
    }

    private static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return state.equals("mounted") || state.equals("mounted_ro");
    }

    public static byte[] bitmapToByteArray(Bitmap bitmap, boolean scaled) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (scaled) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)850, (int)700, (boolean)true);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)baos);
        } else {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    public static byte[] bitmapToByteArray(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 85, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static byte[] fileToByteArray(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            try {
                int readNum;
                while ((readNum = fis.read(buf)) != -1) {
                    bos.write(buf, 0, readNum);
                    System.out.println("read " + readNum + " bytes,");
                }
                return bos.toByteArray();
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTimeStamp(String format) {
        String timeStamp = new SimpleDateFormat("ddMMyyyy_HHmm").format(new Date());
        return "MI_" + timeStamp + "." + format;
    }

    @RequiresApi(api=19)
    public static File getCacheFile(Context context, String nameFile) throws IOException {
        File cacheFile = new File(context.getCacheDir(), nameFile);
        try (InputStream inputStream = context.getAssets().open(nameFile);
             FileOutputStream outputStream = new FileOutputStream(cacheFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            Log.e((String)"Error de excepcion", (String)e.getMessage());
        }
        return cacheFile;
    }
}

