/*
 * Decompiled with CFR 0.152.
 */
package de.derklaro.projects.deer.executor.utils;

import de.derklaro.projects.deer.api.Database;
import de.derklaro.projects.deer.api.writer.FileWriter;
import de.derklaro.projects.deer.executor.BasicDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class DatabaseUtil {
    private DatabaseUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T extends FileWriter> Database<T> loadOrCreateDatabase(@NotNull File file, @NotNull Function<File, T> applier, int valueLength) {
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return new BasicDatabase<T>(file, applier, valueLength);
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Can only load databases which are folders!");
        }
        return new BasicDatabase<T>(file, applier, new Properties());
    }

    public static <T extends FileWriter> Database<T> loadDatabase(@NotNull File file, @NotNull Function<File, T> applier) {
        if (!file.isDirectory()) {
            throw new RuntimeException("Can only load databases which are folders!");
        }
        return new BasicDatabase<T>(file, applier, new Properties());
    }
}

