/*
 * Decompiled with CFR 0.152.
 */
package de.derklaro.projects.deer.executor;

import de.derklaro.projects.deer.api.Database;
import de.derklaro.projects.deer.api.DatabaseDriver;
import de.derklaro.projects.deer.api.provider.DatabaseProvider;
import de.derklaro.projects.deer.api.writer.FileWriter;
import de.derklaro.projects.deer.executor.utils.DatabaseUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicDatabaseDriver
implements DatabaseDriver {
    private BasicDatabaseDriver() {
    }

    @NotNull
    public <T extends FileWriter> Database<T> getDatabase(@NotNull File folder, @NotNull Function<File, T> applier, int valueLength) {
        return DatabaseUtil.loadOrCreateDatabase(folder, applier, valueLength);
    }

    @Nullable
    public <T extends FileWriter> Database<T> getDatabaseIfExists(@NotNull File folder, @NotNull Function<File, T> applier) {
        return DatabaseUtil.loadDatabase(folder, applier);
    }

    public void clearDatabase(@NotNull File database) {
        if (!database.exists() || !database.isDirectory()) {
            return;
        }
        this.clear(database, true);
    }

    public void deleteDatabase(@NotNull File database) {
        if (!database.exists() || !database.isDirectory()) {
            return;
        }
        this.clear(database, false);
        this.clearDatabase(database);
        try {
            Files.delete(database.toPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void clear(File file, final boolean ignoreConfig) {
        try {
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.toFile().getName().equals("config.properties") && ignoreConfig) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        DatabaseProvider.setDatabaseDriver((DatabaseDriver)new BasicDatabaseDriver());
    }
}

