/*
 * Decompiled with CFR 0.152.
 */
package com.denzcoskun.imageslider;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.denzcoskun.imageslider.R;
import com.denzcoskun.imageslider.adapters.ViewPagerAdapter;
import com.denzcoskun.imageslider.constants.ActionTypes;
import com.denzcoskun.imageslider.constants.ScaleTypes;
import com.denzcoskun.imageslider.interfaces.ItemChangeListener;
import com.denzcoskun.imageslider.interfaces.ItemClickListener;
import com.denzcoskun.imageslider.interfaces.TouchListener;
import com.denzcoskun.imageslider.models.SlideModel;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010)\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0014\u0010,\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.J \u0010,\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\n\b\u0002\u00100\u001a\u0004\u0018\u000101J\u000e\u00102\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020+2\u0006\u0010\"\u001a\u00020#J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u00020+2\b\b\u0002\u0010:\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020+R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/denzcoskun/imageslider/ImageSlider;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoCycle", "", "cornerRadius", "currentPage", "delay", "", "dots", "", "Landroid/widget/ImageView;", "[Landroid/widget/ImageView;", "errorImage", "imageCount", "indicatorAlign", "", "itemChangeListener", "Lcom/denzcoskun/imageslider/interfaces/ItemChangeListener;", "pagerDots", "Landroid/widget/LinearLayout;", "period", "placeholder", "selectedDot", "swipeTimer", "Ljava/util/Timer;", "textAlign", "titleBackground", "touchListener", "Lcom/denzcoskun/imageslider/interfaces/TouchListener;", "unselectedDot", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "viewPagerAdapter", "Lcom/denzcoskun/imageslider/adapters/ViewPagerAdapter;", "getGravityFromAlign", "scheduleTimer", "", "setImageList", "imageList", "", "Lcom/denzcoskun/imageslider/models/SlideModel;", "scaleType", "Lcom/denzcoskun/imageslider/constants/ScaleTypes;", "setItemChangeListener", "setItemClickListener", "itemClickListener", "Lcom/denzcoskun/imageslider/interfaces/ItemClickListener;", "setTouchListener", "setupDots", "size", "startSliding", "changeablePeriod", "stopSliding", "imageslider_release"})
public final class ImageSlider
extends RelativeLayout {
    private ViewPager viewPager;
    private LinearLayout pagerDots;
    private ViewPagerAdapter viewPagerAdapter;
    private ImageView[] dots;
    private int currentPage;
    private int imageCount;
    private int cornerRadius;
    private long period;
    private long delay;
    private boolean autoCycle;
    private int selectedDot;
    private int unselectedDot;
    private int errorImage;
    private int placeholder;
    private int titleBackground;
    private String textAlign;
    private String indicatorAlign;
    private Timer swipeTimer;
    private ItemChangeListener itemChangeListener;
    private TouchListener touchListener;

    public final void setImageList(@NotNull List<SlideModel> imageList) {
        Intrinsics.checkParameterIsNotNull(imageList, (String)"imageList");
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.viewPagerAdapter = new ViewPagerAdapter(context, imageList, this.cornerRadius, this.errorImage, this.placeholder, this.titleBackground, this.textAlign);
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.setAdapter((PagerAdapter)this.viewPagerAdapter);
        this.imageCount = imageList.size();
        Collection collection = imageList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.setupDots(imageList.size());
            if (this.autoCycle) {
                this.stopSliding();
                ImageSlider.startSliding$default(this, 0L, 1, null);
            }
        }
    }

    public final void setImageList(@NotNull List<SlideModel> imageList, @Nullable ScaleTypes scaleType) {
        Intrinsics.checkParameterIsNotNull(imageList, (String)"imageList");
        this.viewPagerAdapter = new ViewPagerAdapter(this.getContext(), imageList, this.cornerRadius, this.errorImage, this.placeholder, this.titleBackground, scaleType, this.textAlign);
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.setAdapter((PagerAdapter)this.viewPagerAdapter);
        this.imageCount = imageList.size();
        Collection collection = imageList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.setupDots(imageList.size());
            if (this.autoCycle) {
                ImageSlider.startSliding$default(this, 0L, 1, null);
            }
        }
    }

    public static /* synthetic */ void setImageList$default(ImageSlider imageSlider, List list, ScaleTypes scaleTypes, int n, Object object) {
        if ((n & 2) != 0) {
            scaleTypes = null;
        }
        imageSlider.setImageList(list, scaleTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final void setupDots(int size) {
        String string = this.indicatorAlign;
        int n = 0;
        System.out.println((Object)string);
        LinearLayout linearLayout = this.pagerDots;
        if (linearLayout == null) {
            Intrinsics.throwNpe();
        }
        linearLayout.setGravity(this.getGravityFromAlign(this.indicatorAlign));
        LinearLayout linearLayout2 = this.pagerDots;
        if (linearLayout2 == null) {
            Intrinsics.throwNpe();
        }
        linearLayout2.removeAllViews();
        this.dots = new ImageView[size];
        int n2 = 0;
        n = size;
        while (n2 < n) {
            void i;
            if (this.dots == null) {
                Intrinsics.throwNpe();
            }
            this.dots[i] = new ImageView(this.getContext());
            if (this.dots == null) {
                Intrinsics.throwNpe();
            }
            ImageView imageView = this.dots[i];
            if (imageView == null) {
                Intrinsics.throwNpe();
            }
            imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)this.unselectedDot));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(8, 0, 8, 0);
            LinearLayout linearLayout3 = this.pagerDots;
            if (linearLayout3 == null) {
                Intrinsics.throwNpe();
            }
            if (this.dots == null) {
                Intrinsics.throwNpe();
            }
            linearLayout3.addView((View)this.dots[i], (ViewGroup.LayoutParams)params);
            ++i;
        }
        if (this.dots == null) {
            Intrinsics.throwNpe();
        }
        ImageView imageView = this.dots[0];
        if (imageView == null) {
            Intrinsics.throwNpe();
        }
        imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)this.selectedDot));
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(this){
            final /* synthetic */ ImageSlider this$0;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageSlider.access$setCurrentPage$p(this.this$0, position);
                ImageView[] imageViewArray = ImageSlider.access$getDots$p(this.this$0);
                if (imageViewArray == null) {
                    Intrinsics.throwNpe();
                }
                ImageView[] imageViewArray2 = imageViewArray;
                int n = imageViewArray2.length;
                for (int i = 0; i < n; ++i) {
                    ImageView dot;
                    ImageView imageView = dot = imageViewArray2[i];
                    if (imageView == null) {
                        Intrinsics.throwNpe();
                    }
                    imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.this$0.getContext(), (int)ImageSlider.access$getUnselectedDot$p(this.this$0)));
                }
                ImageView[] imageViewArray3 = ImageSlider.access$getDots$p(this.this$0);
                if (imageViewArray3 == null) {
                    Intrinsics.throwNpe();
                }
                ImageView imageView = imageViewArray3[position];
                if (imageView == null) {
                    Intrinsics.throwNpe();
                }
                imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.this$0.getContext(), (int)ImageSlider.access$getSelectedDot$p(this.this$0)));
                ItemChangeListener itemChangeListener = ImageSlider.access$getItemChangeListener$p(this.this$0);
                if (itemChangeListener == null) {
                    Intrinsics.throwNpe();
                }
                itemChangeListener.onItemChanged(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void startSliding(long changeablePeriod) {
        this.stopSliding();
        this.scheduleTimer(changeablePeriod);
    }

    public static /* synthetic */ void startSliding$default(ImageSlider imageSlider, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = imageSlider.period;
        }
        imageSlider.startSliding(l);
    }

    public final void stopSliding() {
        this.swipeTimer.cancel();
        this.swipeTimer.purge();
    }

    private final void scheduleTimer(long period) {
        Handler handler = new Handler();
        Runnable update2 = new Runnable(this){
            final /* synthetic */ ImageSlider this$0;

            public final void run() {
                if (ImageSlider.access$getCurrentPage$p(this.this$0) == ImageSlider.access$getImageCount$p(this.this$0)) {
                    ImageSlider.access$setCurrentPage$p(this.this$0, 0);
                }
                ViewPager viewPager = ImageSlider.access$getViewPager$p(this.this$0);
                if (viewPager == null) {
                    Intrinsics.throwNpe();
                }
                ImageSlider imageSlider = this.this$0;
                int n = ImageSlider.access$getCurrentPage$p(imageSlider);
                ImageSlider.access$setCurrentPage$p(imageSlider, n + 1);
                viewPager.setCurrentItem(n, true);
            }
            {
                this.this$0 = imageSlider;
            }
        };
        this.swipeTimer = new Timer();
        this.swipeTimer.schedule(new TimerTask(handler, update2){
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Runnable $update;

            public void run() {
                this.$handler.post(this.$update);
            }
            {
                this.$handler = $captured_local_variable$0;
                this.$update = $captured_local_variable$1;
            }
        }, this.delay, period);
    }

    public final void setItemClickListener(@NotNull ItemClickListener itemClickListener) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)itemClickListener, (String)"itemClickListener");
            ViewPagerAdapter viewPagerAdapter = this.viewPagerAdapter;
            if (viewPagerAdapter == null) break block0;
            viewPagerAdapter.setItemClickListener(itemClickListener);
        }
    }

    public final void setItemChangeListener(@NotNull ItemChangeListener itemChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)itemChangeListener, (String)"itemChangeListener");
        this.itemChangeListener = itemChangeListener;
    }

    public final void setTouchListener(@NotNull TouchListener touchListener) {
        Intrinsics.checkParameterIsNotNull((Object)touchListener, (String)"touchListener");
        this.touchListener = touchListener;
        ViewPagerAdapter viewPagerAdapter = this.viewPagerAdapter;
        if (viewPagerAdapter == null) {
            Intrinsics.throwNpe();
        }
        viewPagerAdapter.setTouchListener(touchListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int getGravityFromAlign(@NotNull String textAlign) {
        Intrinsics.checkParameterIsNotNull((Object)textAlign, (String)"textAlign");
        String string = textAlign;
        switch (string.hashCode()) {
            case 2332679: {
                if (!string.equals("LEFT")) return 17;
                return 3;
            }
            case 77974012: {
                if (!string.equals("RIGHT")) return 17;
                return 5;
            }
        }
        return 17;
    }

    @JvmOverloads
    public ImageSlider(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textAlign = "LEFT";
        this.indicatorAlign = "CENTER";
        this.swipeTimer = new Timer();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.image_slider, (ViewGroup)this, true);
        this.viewPager = (ViewPager)this.findViewById(R.id.view_pager);
        this.pagerDots = (LinearLayout)this.findViewById(R.id.pager_dots);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ImageSlider, defStyleAttr, defStyleAttr);
        this.cornerRadius = typedArray.getInt(R.styleable.ImageSlider_iss_corner_radius, 1);
        this.period = typedArray.getInt(R.styleable.ImageSlider_iss_period, 1000);
        this.delay = typedArray.getInt(R.styleable.ImageSlider_iss_delay, 1000);
        this.autoCycle = typedArray.getBoolean(R.styleable.ImageSlider_iss_auto_cycle, false);
        this.placeholder = typedArray.getResourceId(R.styleable.ImageSlider_iss_placeholder, R.drawable.loading);
        this.errorImage = typedArray.getResourceId(R.styleable.ImageSlider_iss_error_image, R.drawable.error);
        this.selectedDot = typedArray.getResourceId(R.styleable.ImageSlider_iss_selected_dot, R.drawable.default_selected_dot);
        this.unselectedDot = typedArray.getResourceId(R.styleable.ImageSlider_iss_unselected_dot, R.drawable.default_unselected_dot);
        this.titleBackground = typedArray.getResourceId(R.styleable.ImageSlider_iss_title_background, R.drawable.gradient);
        if (typedArray.getString(R.styleable.ImageSlider_iss_text_align) != null) {
            String string = typedArray.getString(R.styleable.ImageSlider_iss_text_align);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typedArray.getString(R.s\u2026ageSlider_iss_text_align)");
            this.textAlign = string;
        }
        if (typedArray.getString(R.styleable.ImageSlider_iss_indicator_align) != null) {
            String string = typedArray.getString(R.styleable.ImageSlider_iss_indicator_align);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typedArray.getString(R.s\u2026ider_iss_indicator_align)");
            this.indicatorAlign = string;
        }
        ViewPager viewPager = this.viewPager;
        if (viewPager == null) {
            Intrinsics.throwNpe();
        }
        viewPager.setOnTouchListener(new View.OnTouchListener(){

            public final boolean onTouch(View v, MotionEvent event) {
                MotionEvent motionEvent = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)motionEvent, (String)"event");
                switch (motionEvent.getAction()) {
                    case 2: {
                        TouchListener touchListener = touchListener;
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.MOVE);
                        break;
                    }
                    case 0: {
                        TouchListener touchListener = touchListener;
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.DOWN);
                        break;
                    }
                    case 1: {
                        TouchListener touchListener = touchListener;
                        if (touchListener == null) {
                            Intrinsics.throwNpe();
                        }
                        touchListener.onTouched(ActionTypes.UP);
                        break;
                    }
                }
                return false;
            }
        });
    }

    public /* synthetic */ ImageSlider(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ImageSlider(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ImageSlider(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ int access$getCurrentPage$p(ImageSlider $this) {
        return $this.currentPage;
    }

    public static final /* synthetic */ void access$setCurrentPage$p(ImageSlider $this, int n) {
        $this.currentPage = n;
    }

    public static final /* synthetic */ ImageView[] access$getDots$p(ImageSlider $this) {
        return $this.dots;
    }

    public static final /* synthetic */ void access$setDots$p(ImageSlider $this, ImageView[] imageViewArray) {
        $this.dots = imageViewArray;
    }

    public static final /* synthetic */ int access$getUnselectedDot$p(ImageSlider $this) {
        return $this.unselectedDot;
    }

    public static final /* synthetic */ void access$setUnselectedDot$p(ImageSlider $this, int n) {
        $this.unselectedDot = n;
    }

    public static final /* synthetic */ int access$getSelectedDot$p(ImageSlider $this) {
        return $this.selectedDot;
    }

    public static final /* synthetic */ void access$setSelectedDot$p(ImageSlider $this, int n) {
        $this.selectedDot = n;
    }

    public static final /* synthetic */ ItemChangeListener access$getItemChangeListener$p(ImageSlider $this) {
        return $this.itemChangeListener;
    }

    public static final /* synthetic */ void access$setItemChangeListener$p(ImageSlider $this, ItemChangeListener itemChangeListener) {
        $this.itemChangeListener = itemChangeListener;
    }

    public static final /* synthetic */ int access$getImageCount$p(ImageSlider $this) {
        return $this.imageCount;
    }

    public static final /* synthetic */ void access$setImageCount$p(ImageSlider $this, int n) {
        $this.imageCount = n;
    }

    public static final /* synthetic */ ViewPager access$getViewPager$p(ImageSlider $this) {
        return $this.viewPager;
    }

    public static final /* synthetic */ void access$setViewPager$p(ImageSlider $this, ViewPager viewPager) {
        $this.viewPager = viewPager;
    }

    public static final /* synthetic */ void access$setTouchListener$p(ImageSlider $this, TouchListener touchListener) {
        $this.touchListener = touchListener;
    }
}

