/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.support.rowset;

import java.util.Properties;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.support.rowset.RowSet;
import org.springframework.batch.item.excel.support.rowset.RowSetMetaData;
import org.springframework.util.StringUtils;

public class DefaultRowSet
implements RowSet {
    private final Sheet sheet;
    private final RowSetMetaData metaData;
    private int currentRowIndex = -1;
    private String[] currentRow;

    DefaultRowSet(Sheet sheet, RowSetMetaData metaData) {
        this.sheet = sheet;
        this.metaData = metaData;
    }

    @Override
    public RowSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean next() {
        this.currentRow = null;
        ++this.currentRowIndex;
        if (this.currentRowIndex < this.sheet.getNumberOfRows()) {
            this.currentRow = this.sheet.getRow(this.currentRowIndex);
            return !this.isRowEmpty(this.currentRow);
        }
        return false;
    }

    public boolean isRowEmpty(String[] row) {
        if (row == null) {
            return true;
        }
        for (int c = 0; c < row.length; ++c) {
            if (StringUtils.isEmpty((Object)row[c])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public String[] getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public String getColumnValue(int idx) {
        return this.currentRow[idx];
    }

    @Override
    public Properties getProperties() {
        String[] names = this.metaData.getColumnNames();
        if (names == null) {
            throw new IllegalStateException("Cannot create properties without meta data");
        }
        Properties props = new Properties();
        for (int i = 0; i < this.currentRow.length; ++i) {
            String value = this.currentRow[i];
            if (value == null) continue;
            props.setProperty(names[i], value);
        }
        return props;
    }
}

