/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

public class NoiseSuppressor {
    public static int MODE_MILD;
    public static int MODE_MEDIUM;
    public static int MODE_AGGRESSIVE;
    int samplingFrequency;
    boolean initialized = false;

    public NoiseSuppressor(int samplingFrequency, int mode) {
        this.samplingFrequency = samplingFrequency;
        this.initialized = NoiseSuppressor.nativeCreateNsInstance(samplingFrequency, mode);
        if (!this.initialized) {
            throw new RuntimeException("failed to create org.webrtc.NoiseSuppressor");
        }
    }

    public void setMode(int mode) throws Exception {
        if (!this.initialized) {
            throw new RuntimeException("setMode() called on an unprepared NS instance.");
        }
        long result = 0L;
        if (result != 0L) {
            throw new RuntimeException("setMode() failed, code = " + result);
        }
    }

    public void processAudioFrame(short[] input, short[] output, short numOfSamples) throws Exception {
        if (!this.initialized) {
            throw new RuntimeException("processAudioFrame() called on an unprepared NS instance.");
        }
        int result = (int)NoiseSuppressor.nativeNsProcess(input, output, numOfSamples);
        switch (result) {
            case -3: {
                throw new RuntimeException("processAudioFrame() failed due to NULL output array");
            }
            case -2: {
                throw new RuntimeException("processAudioFrame() failed due to NULL input array");
            }
            case -1: {
                throw new RuntimeException("processAudioFrame() failed due to invalid instance ID");
            }
            case 0: {
                return;
            }
        }
        throw new RuntimeException("processAudioFrame() failed due to unknown error, code = " + result);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.initialized) {
            this.close();
        }
    }

    public void close() {
        if (this.initialized) {
            NoiseSuppressor.nativeFreeNsInstance();
            this.initialized = false;
        }
    }

    private static native boolean nativeCreateNsInstance(int var0, int var1);

    private static native boolean nativeFreeNsInstance();

    private static native long nativeNsProcess(short[] var0, short[] var1, short var2);

    static {
        System.loadLibrary("jingle_peerconnection_so");
        MODE_MILD = 0;
        MODE_MEDIUM = 1;
        MODE_AGGRESSIVE = 2;
    }
}

